﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nw.g3d.nw4f_3dif;
using nw.g3d.iflib;
using nw.g3d.iflib.nw3de;

namespace App.Data
{
    public interface IMaterialOwner : IReferTexture
    {
        ReadOnlyList<Material> Materials
        {
            get;
        }

        // マテリアルアニメーションはモデル側が持ち、fmt では持たないためインターフェイスから除外。
#if false
        IEnumerable<AnimationDocument> AllAnimations
        {
            get;
        }

        IEnumerable<AnimationSet> AnimationSetsWithDefault
        {
            get;
        }
#endif
    }

    static class MaterialOwnerExtensions
    {
        public static Dictionary<string, string> MakeReferenceTexturePaths(this IMaterialOwner owner)
        {
            var doc = (IntermediateFileDocument)owner;
            var texturePaths = new Dictionary<string, string>();
            var pathWithNames = Enumerable.Empty<DocumentManager.PathWithName>();

            foreach (var material in owner.Materials)
            {
                foreach (var sampler in material.ResolvedSamplers)
                {
                    pathWithNames = pathWithNames.Concat(DocumentManager.MakeReferenceTextureFilenames(
                        doc.FileLocation,
                        doc,
                        doc.BaseName,
                        sampler.tex_name).Take(1));

                }
            }

            foreach (var pathWithName in pathWithNames)
            {
                var texturePath = System.IO.Path.GetFullPath(pathWithName.path);
                var texture = DocumentManager.Textures.FirstOrDefault(x => string.Compare(texturePath, x.FilePath, StringComparison.OrdinalIgnoreCase) == 0);

                if (texture != null)
                {
                    texturePaths[texture.Name] = texturePath;
                }
            }

            return texturePaths;
        }

        public static void UpdateReferenceTexturePaths(this IMaterialOwner owner)
        {
            owner.ReferenceTexturePaths = MakeReferenceTexturePaths(owner);
        }

        public static IEnumerable<string> UnresolvedTextures(this IMaterialOwner owner)
        {
            return owner.Materials.SelectMany(x => x.ResolvedSamplerTextureNames).Where(x => !owner.ReferenceTexturePaths.ContainsKey(x)).Distinct();
        }
    }
}
