﻿using App.res;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace App.Data
{
    public partial class MaterialAnimation
    {
        public enum SubType
        {
            Material,
            ShaderParameter,
            Color,
            TextureSRT,
            TexturePattern,
            MaterialVisibility,
        }

        public static string PostFix(SubType subType)
        {
            switch (subType)
            {
                case SubType.Material:
                    return string.Empty;
                case SubType.ShaderParameter:
                    return ShaderParameterAnimationPostFix;
                case SubType.Color:
                    return ColorAnimationPostFix;
                case SubType.TextureSRT:
                    return TextureSRTAnimationPostFix;
                case SubType.TexturePattern:
                    return TexturePatternAnimationPostFix;
                case SubType.MaterialVisibility:
                    return MaterialVisibilityAnimationPostFix;

            }

            throw new InvalidOperationException();
        }

        public static string SubTypeString(SubType subType)
        {
            switch (subType)
            {
                case SubType.Material:
                    return Strings.SubType_MaterialAnimation;
                case SubType.ShaderParameter:
                    return Strings.SubType_ShaderParameterAnimation;
                case SubType.Color:
                    return Strings.SubType_ColorAnimation;
                case SubType.TextureSRT:
                    return Strings.SubType_TexSrtAnimation;
                case SubType.TexturePattern:
                    return Strings.SubType_TexPatternAnimation;
                case SubType.MaterialVisibility:
                    return Strings.SubType_VisibilityAnimation;
            }

            throw new InvalidOperationException();
        }

        public const string ShaderParameterAnimationPostFix = "_fsp";
        public const string ColorAnimationPostFix = "_fcl";
        public const string TextureSRTAnimationPostFix = "_fts";
        public const string TexturePatternAnimationPostFix = "_ftp";
        public const string MaterialVisibilityAnimationPostFix = "_fvm";

        public static SubType NameToType(string Name)
        {
            if (ConfigData.ApplicationConfig.Preset.SeparateMaterialAnimCreationMenu)
            {
                if (Name.EndsWith(ShaderParameterAnimationPostFix))
                {
                    return SubType.ShaderParameter;
                }

                if (Name.EndsWith(ColorAnimationPostFix))
                {
                    return SubType.Color;
                }

                if (Name.EndsWith(TextureSRTAnimationPostFix))
                {
                    return SubType.TextureSRT;
                }

                if (Name.EndsWith(TexturePatternAnimationPostFix))
                {
                    return SubType.TexturePattern;
                }

                if (Name.EndsWith(MaterialVisibilityAnimationPostFix))
                {
                    return SubType.MaterialVisibility;
                }
            }

            return SubType.Material;
        }

        public bool IsShaderParameterType()
        {
            switch (MaterialAnimationSubType)
            {
                case SubType.Material:
                case SubType.ShaderParameter:
                case SubType.Color:
                case SubType.TextureSRT:
                    return true;
            }

            return false;
        }

        public bool IsTextureSrtType()
        {
            switch (MaterialAnimationSubType)
            {
                case SubType.Material:
                case SubType.ShaderParameter:
                case SubType.TextureSRT:
                    return true;
            }

            return false;
        }

        public bool IsColorType()
        {
            switch (MaterialAnimationSubType)
            {
                case SubType.Material:
                case SubType.ShaderParameter:
                case SubType.Color:
                    return true;
            }

            return false;
        }

        public bool IsTexturePatternType()
        {
            switch (MaterialAnimationSubType)
            {
                case SubType.Material:case SubType.TexturePattern:
                    return true;
            }

            return false;
        }

        public bool IsVisibilityType()
        {
            switch (MaterialAnimationSubType)
            {
                case SubType.Material:case SubType.MaterialVisibility:
                    return true;
            }

            return false;
        }
    }
}
