﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// ＵＩユーザーコントロールクラス。
    /// </summary>
    [ToolboxBitmap(typeof(UserControl))]
    [ToolboxItem(false)]
    public partial class UIUserControl : UserControl
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIUserControl()
        {
#if false
            InitializeComponent();
#else
            Font = TheApp.GuiFont;
#endif
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                if (UIControlEventSuppressBlock.Enabled)
                {
                    return false;
                }
                return base.CanRaiseEvents;
            }
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        [Localizable(false)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override Font Font
        {
            // LocalizableAttribute を false にしないと、派生クラスで
            // Localizable プロパティを true にした時に、既定のフォントが
            // 使用されるようになってしまうので注意
            get { return base.Font;  }
            set { base.Font = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public override RightToLeft RightToLeft
        {
            get { return base.RightToLeft;  }
            set { base.RightToLeft = value; }
        }
        #endregion
    }
}
