﻿using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Windows.Forms.Design;
using App.Utility;

namespace App.Controls
{
    public class UITextBoxEx : UITextBox
    {
        public event EventHandler WatermarkTextChanged = null;

        private string watermarkText = string.Empty;

        [DefaultValue("")]
        [Description("テキストボックスが空のときに表示する透かし文字。")]
        public string WatermarkText
        {
            get
            {
                return watermarkText;
            }
            set
            {
                watermarkText = !string.IsNullOrEmpty(value) ? value : string.Empty;
                OnWatermarkTextChanged(EventArgs.Empty);
            }
        }

        public UITextBoxEx()
        { }

        protected virtual void OnWatermarkTextChanged(EventArgs e)
        {
            if (CanRaiseEvents)
            {
                if (WatermarkTextChanged != null)
                {
                    WatermarkTextChanged(this, e);
                }
            }

            // 透かし文字更新のために再描画。
            if (string.IsNullOrEmpty(Text))
            {
                Invalidate();
            }
        }

        protected override void OnTextChanged(EventArgs e)
        {
            base.OnTextChanged(e);

            // 空文字に変わった場合は透かし文字表示のために再描画。
            if (string.IsNullOrEmpty(Text))
            {
                Invalidate();
            }
        }

        protected override void WndProc(ref System.Windows.Forms.Message m)
        {
            switch (m.Msg)
            {
                case App.Win32.WM.WM_PAINT:
                    if (string.IsNullOrEmpty(Text) && !string.IsNullOrEmpty(WatermarkText))
                    {
                        base.WndProc(ref m);
                        using (var g = System.Drawing.Graphics.FromHwnd(Handle))
                        {
                            var rect = ClientRectangle;
                            System.Windows.Forms.TextRenderer.DrawText(
                                g,
                                WatermarkText,
                                Font,
                                rect,
                                System.Drawing.SystemColors.GrayText,
                                System.Windows.Forms.TextFormatFlags.Top | System.Windows.Forms.TextFormatFlags.Left);
                        }
                        return;
                    }
                    break;
                default:
                    break;
            }
            base.WndProc(ref m);
        }
    }
}
