﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Drawing;
using System.Windows.Forms;
using App.Data;
using App.Utility;

namespace App.Controls
{
    public partial class TexturePreviewToolTip : Form
    {
        public TexturePreviewToolTip()
        {
            InitializeComponent();

            Paint += (s, e) =>
            {
                if (Texture != null)
                {
                    //var image = Texture.ColorLargeThumbnail;
                    //if (image != null)
                    //{
                    //    BitmapUtility.DrawTextureImage(e.Graphics, image, Width, Height, Texture.Is1d);
                    //}
                    Texture.DrawColorThumbnailFit(e.Graphics, new Rectangle(0,0, Width, Height));
                }
            };

            MouseMove += (s, e) =>
            {
                Location = PointToScreen(new Point(e.X + 1, e.Y + 1));
            };

            ImageWidth  = 192;
            ImageHeight = 192;
        }

        private Texture texture_;
        public Texture Texture
        {
            get
            {
                return texture_;
            }

            set
            {
                texture_ = value;
                Invalidate();
            }
        }

        public int ImageWidth{ get; set; }
        public int ImageHeight{ get; set; }

        public new void Show()
        {
            Size = new Size(ImageWidth, ImageHeight);

            if (Visible == false)
            {
                base.Show();
            }

            Opacity = 100;
        }

        public new void Hide()
        {
            Size = new Size(0, 0);
            Opacity = 0;
            Location = new Point(-10000, -10000);
        }
    }
}
