﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace App.Controls
{
    public partial class SameFileReload : OkCancelDialog
    {
        public  bool AutoReload { get; set; }
        public SameFileReload(IEnumerable<string> files)
        {
            InitializeComponent();
            AutoReload = false;
            foreach (var file in files)
            {
                lbxFiles.AddItem(file, null);
            }
        }

        private void chkAutoReload_CheckedChanged(object sender, EventArgs e)
        {
            AutoReload = chkAutoReload.Checked;
        }
    }
}
