﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using App.Data;

namespace App.Controls
{
    public partial class ModelSelectDialog : OkCancelDialog
    {
        public ModelSelectDialog(IEnumerable<Model> models, AnimationDocument animation, string chkText = null)
        {
            InitializeComponent();

            Debug.Assert(models.Any());

            foreach (Model model in models)
            {
                lbxTargets.AddItem(model.Name, model, model.ObjectIcon);
            }
            lbxTargets.SelectedIndex = 0;
            uiTextBox1.Text = animation.FileName;
            if (!string.IsNullOrEmpty(chkText))
            {
                chkCheck.Visible = true;
                chkCheck.Text = chkText;
            }
        }

        public GuiObject Selected
        {
            get { return (GuiObject)lbxTargets.SelectedItemData; }
        }

        public bool Checked { get { return chkCheck.Checked; }}
    }
}
