﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.ComponentModel;
using System.Windows.Forms;

namespace App.Controls
{
    [ToolboxItem(true)]
    public sealed class ImagePanel : UIControl
    {
        private HintToolTip ttpHint_;

        private string toolTipText_ = string.Empty;
        public string ToolTipText
        {
            get
            {
                return toolTipText_;
            }

            set
            {
                toolTipText_ = value;

                if (ttpHint_ == null)
                {
                    ttpHint_ = new App.Controls.HintToolTip();
                }

                ttpHint_.SetToolTip(this, toolTipText_);
            }
        }

        public ImagePanel()
        {
            base.SetStyle(ControlStyles.Selectable, false);
            base.DoubleBuffered = true;
            base.TabStop = false;
        }
    }
}
