﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace App.Controls
{
    public partial class FindBar : App.Controls.UIUserControl
    {
        private class CustomDisposer : IDisposable
        {
            private readonly Action OnDisposing;

            public CustomDisposer(Action onDisposing)
            {
                OnDisposing = onDisposing;
            }

            public void Dispose()
            {
                if (OnDisposing != null)
                {
                    OnDisposing();
                }
            }
        }

        private bool forceEventRaising = false;

        public event System.EventHandler EnterKeyDown = null;

        public event System.EventHandler CloseButtonClick
        {
            add
            {
                btnClose.Click += value;
            }
            remove
            {
                btnClose.Click -= value;
            }
        }

        public string WatermarkText
        {
            get
            {
                return tbxSearch.WatermarkText;
            }
            set
            {
                tbxSearch.WatermarkText = value;
            }
        }

        public bool IsEditing
        {
            get
            {
                return tbxSearch.Focused;
            }
        }

        public override string Text
        {
            get
            {
                return tbxSearch.Text;
            }
            set
            {
                tbxSearch.Text = value;
            }
        }

        protected override bool CanRaiseEvents
        {
            get
            {
                return forceEventRaising ? true : base.CanRaiseEvents;
            }
        }

        public FindBar()
        {
            InitializeComponent();

            tbxSearch.BorderStyle = BorderStyle.None;
            btnClose.FlatStyle = FlatStyle.Flat;
            btnClose.BackColor = tbxSearch.BackColor;
            btnClose.ForeColor = tbxSearch.BackColor;
            BackColor = tbxSearch.BackColor;
            ForeColor = tbxSearch.BackColor;
            BorderStyle = BorderStyle.FixedSingle;

            tbxSearch.TextChanged += (ss, ee) =>
            {
                OnTextChanged(ee);
            };
            tbxSearch.KeyDown += (ss, ee) =>
            {
                if (ee.KeyCode == Keys.Enter)
                {
                    if (EnterKeyDown != null)
                    {
                        EnterKeyDown(this, EventArgs.Empty);
                    }
                }
            };
        }

        public void InvokeMethodWithForceEventRaising(System.Reflection.MethodInfo method, object[] parameters)
        {
            // method 実行時に例外が発生すると forceEventRaising を元に戻せなくなるので、
            // 元に戻す処理の CustomDisposer を using してから method を実行する。
            var oForceEventRaising = forceEventRaising;
            using (var disposer = new CustomDisposer(() => { forceEventRaising = oForceEventRaising; }))
            {
                forceEventRaising = true;
                method.Invoke(this, parameters);
            }
        }

        protected override void OnGotFocus(EventArgs e)
        {
            // フォーカスをテキストボックスに移すので、base.OnGotFocus() は握りつぶす。
            tbxSearch.Focus();
            tbxSearch.SelectAll();
        }

        protected override void OnVisibleChanged(EventArgs e)
        {
            if (Visible)
            {
                tbxSearch.Focus();
                tbxSearch.SelectAll();
            }
            base.OnVisibleChanged(e);
        }
    }
}
