﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using App.Data;
using App.Utility;

namespace App.Controls
{
    /// <summary>
    /// 編集カラーマーククラス。
    /// </summary>
    [ToolboxItem(true)]
    public sealed partial class EditColorMark : UIUserControl
    {
        private RgbaColor? color;

        public RgbaColor? Color
        {
            get
            {
                return color;
            }

            set
            {
                color = value;
                Invalidate();
            }
        }

        private bool isMouseOver = false;
        private bool isMouseDown = false;

        public float Gamma { get; set; }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public EditColorMark()
        {
            InitializeComponent();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            if (Enabled)
            {
                if (isMouseOver)
                {
                    if (isMouseDown)
                    {
                        EditColorUtility.Draw(EditColorUtility.MouseState.MouseDown, Color, e.Graphics, 0, 0, gamma: Gamma);
                    }
                    else
                    {
                        EditColorUtility.Draw(EditColorUtility.MouseState.MouseOver, Color, e.Graphics, 0, 0, gamma: Gamma);
                    }
                }
                else{
                    EditColorUtility.Draw(EditColorUtility.MouseState.Normal, Color, e.Graphics, 0, 0, gamma: Gamma);
                }
            }
            else
            {
                EditColorUtility.Draw(EditColorUtility.MouseState.Disable, RgbaColor.FromColor(SystemColors.ButtonFace), e.Graphics, 0, 0, gamma: Gamma);
            }
        }

        private void SymbolColorMark_MouseDown(object sender, MouseEventArgs e)
        {
            if (Enabled)
            {
                isMouseDown = true;
                Invalidate();
            }
        }

        private void SymbolColorMark_MouseUp(object sender, MouseEventArgs e)
        {
            if (Enabled)
            {
                isMouseDown = false;
                Invalidate();
            }
        }

        private void SymbolColorMark_MouseLeave(object sender, EventArgs e)
        {
            if (Enabled)
            {
                isMouseOver = false;
                Invalidate();
            }
        }

        private void SymbolColorMark_MouseEnter(object sender, EventArgs e)
        {
            if (Enabled)
            {
                isMouseOver = true;
                Invalidate();
            }
        }
    }
}
