﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Linq;
using App.ConfigData;
using App.res;

namespace App.Controls
{
    public partial class DisconnectViewerDialog : App.Controls.OkDialog
    {
        public DisconnectViewerDialog(string warning, bool showReconnectOption)
        {
            InitializeComponent();
            lblMessage.Text = warning;
            chbReconnect.Visible = showReconnectOption;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool OnResultOk()
        {
            return true;
        }

        private void chbReconnect_CheckedChanged(object sender, System.EventArgs e)
        {
            ApplicationConfig.SaveUserSetting();
        }
    }
}
