﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// ダイアログ結果ボタンクラス。
    /// 基本ダイアログクラスのボタンに使用します。
    /// </summary>
    public sealed class DialogResultButton : UIButton
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public DialogResultButton()
        {
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public override Color BackColor
        {
            get { return base.BackColor;  }
            set { base.BackColor = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public override Cursor Cursor
        {
            get { return base.Cursor;  }
            set { base.Cursor = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new FlatStyle FlatStyle
        {
            get { return base.FlatStyle;  }
            set { base.FlatStyle = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public override Font Font
        {
            get { return base.Font;  }
            set { base.Font = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public override Color ForeColor
        {
            get { return base.ForeColor;  }
            set { base.ForeColor = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public override ContentAlignment TextAlign
        {
            get { return base.TextAlign;  }
            set { base.TextAlign = value; }
        }
        #endregion

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override Size DefaultSize
        {
            get { return new Size(72, base.DefaultSize.Height); }
        }
        #endregion
    }
}
