﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace App.Controls
{
    public partial class PresetVertexAttributeAssignDialog : OkCancelDialog
    {
        /// <summary>
        /// Tag に設定するデータ
        /// </summary>
        public class TagData
        {
            public TeamConfig.Preset.VertexAttributeAssignPreset VertexAttributeAssignPreset;

            public TagData(TeamConfig.Preset.VertexAttributeAssignPreset vertexAttributeAssignPreset)
            {
                VertexAttributeAssignPreset = vertexAttributeAssignPreset;
            }
        }

        const int EM_SETCUEBANNER = 0x1500 + 1;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public PresetVertexAttributeAssignDialog()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            // 入力必須項目に設定。
            if (tbxVertexAttributeAssignName.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(tbxVertexAttributeAssignName.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return !string.IsNullOrEmpty(tbxVertexAttributeAssignName.Text); });
            }

            var data = (TagData)Tag;
            tbxVertexAttributeAssignName.Text = data.VertexAttributeAssignPreset.Name;
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if ((DialogResult == DialogResult.OK) && !acceptable.All(x => x()))
            {
                e.Cancel = true;
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                data.VertexAttributeAssignPreset.Name = CorrectString(data.VertexAttributeAssignPreset.Name, tbxVertexAttributeAssignName.Text);
            }
        }
    }
}
