﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace App.Controls
{
    public partial class PresetLightAnimTargetDialog : OkCancelDialog
    {
        /// <summary>
        /// Tag に設定するデータ
        /// </summary>
        public class TagData
        {
            public TeamConfig.Preset.LightAnimPreset.LightAnimTargetType LightAnimTargetType;
            public TeamConfig.Preset.LightAnimPreset.LightAnimTargetType[] AssignedLightAnimTargetTypes;

            public TagData(TeamConfig.Preset.LightAnimPreset.LightAnimTargetType lightAnimTargetType, TeamConfig.Preset.LightAnimPreset.LightAnimTargetType[] assignedLightAnimTargetTypes)
            {
                LightAnimTargetType = lightAnimTargetType;
                AssignedLightAnimTargetTypes = assignedLightAnimTargetTypes;
            }
        }

        const int EM_SETCUEBANNER = 0x1500 + 1;
        const int CB_SETCUEBANNER = 0x1703;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public PresetLightAnimTargetDialog()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            var data = (TagData)Tag;
            var lightAnimTargetType = data.LightAnimTargetType;
            var anotherTargets = data.AssignedLightAnimTargetTypes.Where(x => x != lightAnimTargetType).Select(y => y.Target).Distinct().ToArray();

            // ターゲットの重複除去と、aim と direction の排他選択。
            var targets = Enum.GetValues(typeof(TeamConfig.Preset.AnimTargetEnum)).Cast<TeamConfig.Preset.AnimTargetEnum>().Where(x => !anotherTargets.Contains(x)).ToList();
            if (anotherTargets.Contains(TeamConfig.Preset.AnimTargetEnum.aim))
            {
                targets.Remove(TeamConfig.Preset.AnimTargetEnum.direction);
            }
            if (anotherTargets.Contains(TeamConfig.Preset.AnimTargetEnum.direction))
            {
                targets.Remove(TeamConfig.Preset.AnimTargetEnum.aim);
            }

            // 作成したターゲットをコンボボックスに設定。
            cbxLightAnimTarget.Items.Clear();
            cbxLightAnimTarget.Items.AddRange(targets.Select(x => new UIListControlItem(x.ToString(), x)).ToArray());
            cbxLightAnimTarget.SelectedItem = cbxLightAnimTarget.Items.Cast<UIListControlItem>().FirstOrDefault(x => (TeamConfig.Preset.AnimTargetEnum)x.Data == lightAnimTargetType.Target);
            tbxLightAnimTargetDefaultValue.Text = lightAnimTargetType.DefaultValue;

            // 入力必須項目に設定。
            if (cbxLightAnimTarget.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(cbxLightAnimTarget.Handle, CB_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return cbxLightAnimTarget.SelectedItem != null; });
            }

            // 書式を設定。
            if (tbxLightAnimTargetDefaultValue.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.PresetLightAnimTarget_DefaultValueCueBanner);
                Win32.NativeMethods.SendMessage(tbxLightAnimTargetDefaultValue.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
            }
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if ((DialogResult == DialogResult.OK) && !acceptable.All(x => x()))
            {
                e.Cancel = true;
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                if (cbxLightAnimTarget.SelectedItem != null)
                {
                    data.LightAnimTargetType.Target = (TeamConfig.Preset.AnimTargetEnum)((UIListControlItem)cbxLightAnimTarget.SelectedItem).Data;
                }
                data.LightAnimTargetType.DefaultValue = CorrectString(data.LightAnimTargetType.DefaultValue, tbxLightAnimTargetDefaultValue.Text);
            }
        }
    }
}
