﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.WindowsAPICodePack.Dialogs;

namespace App.Controls
{
    public partial class FileIoSearchPathDialog : OkCancelDialog
    {
        /// <summary>
        /// Tag に設定するデータ
        /// </summary>
        public class TagData
        {
            public TeamConfig.FileIo.SearchPath SearchPath;

            public TagData(TeamConfig.FileIo.SearchPath searchPath)
            {
                SearchPath = searchPath;
            }
        }

        const int EM_SETCUEBANNER = 0x1500 + 1;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public FileIoSearchPathDialog()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            // 入力必須項目に設定。
            if (tbxSearchPath.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(tbxSearchPath.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return !string.IsNullOrEmpty(tbxSearchPath.Text); });
            }

            var data = (TagData)Tag;
            tbxSearchPath.Text = data.SearchPath.pathXml;
            tbxSearchPathName.Text = data.SearchPath.Name;
            cbxRecursive.Checked = data.SearchPath.Recursive;
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if ((DialogResult == DialogResult.OK) && !acceptable.All(x => x()))
            {
                e.Cancel = true;
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                data.SearchPath.pathXml = CorrectString(data.SearchPath.pathXml, tbxSearchPath.Text);
                data.SearchPath.Name = CorrectString(data.SearchPath.Name, tbxSearchPathName.Text);
                data.SearchPath.Recursive = cbxRecursive.Checked;
            }
        }

        private void btnSearchPath_Click(object sender, EventArgs e)
        {
            using (var dialog = new CommonOpenFileDialog()
            {
                Title = res.Strings.IO_SpecifySearchDirectory,
                IsFolderPicker = true
            })
            {
                var initDir = System.Environment.ExpandEnvironmentVariables(tbxSearchPath.Text);
                if (!string.IsNullOrEmpty(initDir))
                {
                    // 期待通りに動作させるにはディレクトリセパレータを正しておく必要がある。
                    dialog.InitialDirectory = initDir.Replace(System.IO.Path.AltDirectorySeparatorChar, System.IO.Path.DirectorySeparatorChar);
                }

                if (dialog.ShowDialog(Handle) == CommonFileDialogResult.Ok)
                {
                    tbxSearchPath.Text = dialog.FileName;
                }
            }
        }
    }
}
