﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.WindowsAPICodePack.Dialogs;

namespace App.Controls
{
    public partial class FileIoParentMaterialPathDialog : OkCancelDialog
    {
        /// <summary>
        /// Tag に設定するデータ
        /// </summary>
        public class TagData
        {
            public TeamConfig.FileIo.ParentMaterialPath ParentMaterialPath;

            public TagData(TeamConfig.FileIo.ParentMaterialPath parentMaterialPath)
            {
                ParentMaterialPath = parentMaterialPath;
            }
        }

        const int EM_SETCUEBANNER = 0x1500 + 1;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public FileIoParentMaterialPathDialog()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            // 入力必須項目に設定。
            if (tbxParentMaterialPath.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(tbxParentMaterialPath.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return !string.IsNullOrEmpty(tbxParentMaterialPath.Text); });
            }

            var data = (TagData)Tag;
            tbxParentMaterialPath.Text = data.ParentMaterialPath.pathXml;
            tbxParentMaterialPathName.Text = data.ParentMaterialPath.Name;
            cbxRecursive.Checked = data.ParentMaterialPath.Recursive;
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if ((DialogResult == DialogResult.OK) && !acceptable.All(x => x()))
            {
                e.Cancel = true;
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                data.ParentMaterialPath.pathXml = CorrectString(data.ParentMaterialPath.pathXml, tbxParentMaterialPath.Text);
                data.ParentMaterialPath.Name = CorrectString(data.ParentMaterialPath.Name, tbxParentMaterialPathName.Text);
                data.ParentMaterialPath.Recursive = cbxRecursive.Checked;
            }
        }

        private void btnParentMaterialPath_Click(object sender, EventArgs e)
        {
            using (var dialog = new FolderOrFileBrowserDialog()
            {
                Description = res.Strings.IO_SpecifyParentMaterialPath,
                IncludeFiles = true
            })
            {
                try
                {
                    var initPath = System.Environment.ExpandEnvironmentVariables(tbxParentMaterialPath.Text);
                    if (!string.IsNullOrEmpty(initPath))
                    {
                        // 期待通りに動作させるにはディレクトリセパレータを正しておく必要がある。
                        dialog.SelectedPath = initPath.Replace(System.IO.Path.AltDirectorySeparatorChar, System.IO.Path.DirectorySeparatorChar);
                    }
                }
                catch
                { }

                if (dialog.ShowDialog(this) == DialogResult.OK)
                {
                    tbxParentMaterialPath.Text = dialog.SelectedPath;
                }
            }
        }
    }
}
