﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.WindowsAPICodePack.Dialogs;

namespace App.Controls
{
    public partial class FileIoAttachPathDialog : OkCancelDialog
    {
        /// <summary>
        /// Tag に設定するデータ
        /// </summary>
        public class TagData
        {
            public TeamConfig.FileIo.AttachPath AttachPath;

            public TagData(TeamConfig.FileIo.AttachPath attachPath)
            {
                AttachPath = attachPath;
            }
        }

        const int EM_SETCUEBANNER = 0x1500 + 1;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public FileIoAttachPathDialog()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            // 入力必須項目に設定。
            if (tbxAttachPath.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(tbxAttachPath.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return !string.IsNullOrEmpty(tbxAttachPath.Text); });
            }

            // 書式を設定。
            if (tbxAttachPathFilter.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.FileIoAttachPath_FilterCueBanner);
                Win32.NativeMethods.SendMessage(tbxAttachPathFilter.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
            }

            var data = (TagData)Tag;
            tbxAttachPath.Text = data.AttachPath.pathXml;
            tbxAttachPathFilter.Text = data.AttachPath.Filter;
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if ((DialogResult == DialogResult.OK) && !acceptable.All(x => x()))
            {
                e.Cancel = true;
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                data.AttachPath.pathXml = CorrectString(data.AttachPath.pathXml, tbxAttachPath.Text);
                data.AttachPath.Filter = CorrectString(data.AttachPath.Filter, tbxAttachPathFilter.Text);
            }
        }

        private void btnAttachPath_Click(object sender, EventArgs e)
        {
            using (var dialog = new CommonOpenFileDialog()
            {
                Title = res.Strings.IO_SpecifySearchDirectory,
                IsFolderPicker = true
            })
            {
                var initDir = System.Environment.ExpandEnvironmentVariables(tbxAttachPath.Text);
                if (!string.IsNullOrEmpty(initDir))
                {
                    // 期待通りに動作させるにはディレクトリセパレータを正しておく必要がある。
                    dialog.InitialDirectory = initDir.Replace(System.IO.Path.AltDirectorySeparatorChar, System.IO.Path.DirectorySeparatorChar);
                }

                if (dialog.ShowDialog(Handle) == CommonFileDialogResult.Ok)
                {
                    tbxAttachPath.Text = dialog.FileName;
                }
            }
        }
    }
}
