﻿// ---------------------------------------------------------------------------
//  Project:  NintendoWare
//
//  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.
//
//  These coded instructions, statements, and computer programs contain proprietary
//  information of Nintendo and/or its licensed developers and are protected by
//  national and international copyright laws. They may not be disclosed to third
//  parties or copied or duplicated in any form, in whole or in part, without the
//  prior written consent of Nintendo.
//
//  The content herein is highly confidential and should be handled accordingly.
// ---------------------------------------------------------------------------

using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;

namespace ColorPicker
{
    /// <summary>
    /// Hueスライダーコントロールクラス。
    /// </summary>
    public class HueBar : ColorSlider
    {
        /// <summary>
        /// 必要なデザイナ変数です。
        /// </summary>
        private System.ComponentModel.Container components = null;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public HueBar()
        {
            // この呼び出しは、Windows.Forms フォーム デザイナで必要です。
            InitializeComponent();

            //	ちらつきの防止用
            SetStyle( ControlStyles.UserPaint | ControlStyles.AllPaintingInWmPaint | ControlStyles.DoubleBuffer, true );
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #region コンポーネント デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();
        }
        #endregion

        #region オーバーライド

        /// <summary>
        /// ColorValue計算用の幅を返す
        /// </summary>
        /// <returns></returns>
        protected override int GetBarSize()
        {
            return ClientSize.Height;
        }

        /// <summary>
        /// OnPaintのオーバーライド（ビットマップ表示）
        /// </summary>
        /// <param name="e"></param>
        protected override void OnPaint(PaintEventArgs e)
        {
            if( DesignMode )
                return;

            base.OnPaint(e);
            if( Enabled )
            {
                Graphics g = e.Graphics;
                using( Pen blackPen   = new Pen( Color.Black, 3 ) )
                {
                    g.DrawRectangle( blackPen, 1, SliderValue-1, Size.Width-3, 2 );
                    g.DrawRectangle( Pens.White, 1, SliderValue-1, Size.Width-3, 2 );
                }
            }
        }

        /// <summary>
        /// スライダーの値を取得
        /// </summary>
        /// <param name="e"></param>
        /// <returns></returns>
        protected override int	GetMousePoint(MouseEventArgs e)
        {
            return e.Y;
        }

        /// <summary>
        /// 指定位置色の取得
        /// </summary>
        /// <param name="p">カラーを取得する位置</param>
        /// <returns>選択色</returns>
        public override RGB GetPointColor(float p)
        {
            return m_color;
        }

        #endregion

        /// <summary>
        /// 表示Bitmapの作成
        /// </summary>
        public void CreateColorBitmap()
        {
            //	マウスダウン中は変更しない
            if( m_isMouseDown )
                return;

            //	BMPをラインで書き換え
            m_imageBMP	= new Bitmap( ClientSize.Width, ClientSize.Height );
            using( Graphics g = Graphics.FromImage( m_imageBMP ) )
            using( LinearGradientBrush brBrush	= new LinearGradientBrush( g.VisibleClipBounds, Color.Blue, Color.Red, 90f, false ) )
            {
                //brBrush.GammaCorrection
                Color[] colorArray	= { Color.Red, Color.Yellow, Color.FromArgb( 0, 255, 0 ), Color.Cyan, Color.Blue, Color.Magenta, Color.Red };
                float[] posArray	= { 0.0f, 0.1687f, 0.3314f, 0.498f, 0.6628f, 0.8333f, 1.0f };

                ColorBlend colorBlend	= new ColorBlend();
                colorBlend.Colors		= colorArray;
                colorBlend.Positions	= posArray;
                brBrush.InterpolationColors	= colorBlend;
                g.FillRectangle( brBrush, g.VisibleClipBounds );
            }
            Invalidate();
        }
    }
}
