﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Windows.Forms;
using App.Utility;
using nw.g3d.nw4f_3dif;

namespace App.Controls
{
    public partial class ColorComponentSelectButtonPopup : UIUserControl
    {
        public enum ButtonType{
            Ok,
            Cancel
        };

        public ButtonType ClosedButton{	get; set;	}
        public texture_info_comp_selValue[] Value
        {
            get
            {
                var value = new texture_info_comp_selValue[4];
                {
                         if (rbnRR.Checked){	value[0] = (texture_info_comp_selValue)rbnRR.Tag;	}
                    else if (rbnRG.Checked){	value[0] = (texture_info_comp_selValue)rbnRG.Tag;	}
                    else if (rbnRB.Checked){	value[0] = (texture_info_comp_selValue)rbnRB.Tag;	}
                    else if (rbnRA.Checked){	value[0] = (texture_info_comp_selValue)rbnRA.Tag;	}
                    else if (rbnR0.Checked){	value[0] = (texture_info_comp_selValue)rbnR0.Tag;	}
                    else if (rbnR1.Checked){	value[0] = (texture_info_comp_selValue)rbnR1.Tag;	}
                    else{						Debug.Assert(false);								}

                         if (rbnGR.Checked){	value[1] = (texture_info_comp_selValue)rbnGR.Tag;	}
                    else if (rbnGG.Checked){	value[1] = (texture_info_comp_selValue)rbnGG.Tag;	}
                    else if (rbnGB.Checked){	value[1] = (texture_info_comp_selValue)rbnGB.Tag;	}
                    else if (rbnGA.Checked){	value[1] = (texture_info_comp_selValue)rbnGA.Tag;	}
                    else if (rbnG0.Checked){	value[1] = (texture_info_comp_selValue)rbnG0.Tag;	}
                    else if (rbnG1.Checked){	value[1] = (texture_info_comp_selValue)rbnG1.Tag;	}
                    else{						Debug.Assert(false);								}

                         if (rbnBR.Checked){	value[2] = (texture_info_comp_selValue)rbnBR.Tag;	}
                    else if (rbnBG.Checked){	value[2] = (texture_info_comp_selValue)rbnBG.Tag;	}
                    else if (rbnBB.Checked){	value[2] = (texture_info_comp_selValue)rbnBB.Tag;	}
                    else if (rbnBA.Checked){	value[2] = (texture_info_comp_selValue)rbnBA.Tag;	}
                    else if (rbnB0.Checked){	value[2] = (texture_info_comp_selValue)rbnB0.Tag;	}
                    else if (rbnB1.Checked){	value[2] = (texture_info_comp_selValue)rbnB1.Tag;	}
                    else{						Debug.Assert(false);								}

                         if (rbnAR.Checked){	value[3] = (texture_info_comp_selValue)rbnAR.Tag;	}
                    else if (rbnAG.Checked){	value[3] = (texture_info_comp_selValue)rbnAG.Tag;	}
                    else if (rbnAB.Checked){	value[3] = (texture_info_comp_selValue)rbnAB.Tag;	}
                    else if (rbnAA.Checked){	value[3] = (texture_info_comp_selValue)rbnAA.Tag;	}
                    else if (rbnA0.Checked){	value[3] = (texture_info_comp_selValue)rbnA0.Tag;	}
                    else if (rbnA1.Checked){	value[3] = (texture_info_comp_selValue)rbnA1.Tag;	}
                    else{						Debug.Assert(false);								}
                }
                return value;
            }
        }
        public texture_info_comp_selValue[] OrgValue
        {
            get{ return ObjectUtility.Clone(orgValue_); }
        }

        private readonly texture_info_comp_selValue[]	orgValue_;
        private readonly ToolStripDropDown				parent_;

        public ColorComponentSelectButtonPopup(texture_info_comp_selValue[] srcValue, ToolStripDropDown parent)
        {
            InitializeComponent();

            rbnRR.Tag = texture_info_comp_selValue.r;
            rbnRG.Tag = texture_info_comp_selValue.g;
            rbnRB.Tag = texture_info_comp_selValue.b;
            rbnRA.Tag = texture_info_comp_selValue.a;
            rbnR0.Tag = texture_info_comp_selValue.Item0;
            rbnR1.Tag = texture_info_comp_selValue.Item1;
            rbnGR.Tag = texture_info_comp_selValue.r;
            rbnGG.Tag = texture_info_comp_selValue.g;
            rbnGB.Tag = texture_info_comp_selValue.b;
            rbnGA.Tag = texture_info_comp_selValue.a;
            rbnG0.Tag = texture_info_comp_selValue.Item0;
            rbnG1.Tag = texture_info_comp_selValue.Item1;
            rbnBR.Tag = texture_info_comp_selValue.r;
            rbnBG.Tag = texture_info_comp_selValue.g;
            rbnBB.Tag = texture_info_comp_selValue.b;
            rbnBA.Tag = texture_info_comp_selValue.a;
            rbnB0.Tag = texture_info_comp_selValue.Item0;
            rbnB1.Tag = texture_info_comp_selValue.Item1;
            rbnAR.Tag = texture_info_comp_selValue.r;
            rbnAG.Tag = texture_info_comp_selValue.g;
            rbnAB.Tag = texture_info_comp_selValue.b;
            rbnAA.Tag = texture_info_comp_selValue.a;
            rbnA0.Tag = texture_info_comp_selValue.Item0;
            rbnA1.Tag = texture_info_comp_selValue.Item1;

            orgValue_ = ObjectUtility.Clone(srcValue);
            parent_   = parent;
            ClosedButton = ButtonType.Ok;

            UpdateForm(srcValue);
        }

        private void btnReset_Click(object sender, EventArgs e)
        {
            UpdateForm(orgValue_);
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            ClosedButton = ButtonType.Ok;
            parent_.Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            ClosedButton = ButtonType.Cancel;
            parent_.Close();
        }

        private void UpdateForm(texture_info_comp_selValue[] srcValue)
        {
            rbnRR.SetCheckedByTag(srcValue[0]);
            rbnRG.SetCheckedByTag(srcValue[0]);
            rbnRB.SetCheckedByTag(srcValue[0]);
            rbnRA.SetCheckedByTag(srcValue[0]);
            rbnR0.SetCheckedByTag(srcValue[0]);
            rbnR1.SetCheckedByTag(srcValue[0]);
            rbnGR.SetCheckedByTag(srcValue[1]);
            rbnGG.SetCheckedByTag(srcValue[1]);
            rbnGB.SetCheckedByTag(srcValue[1]);
            rbnGA.SetCheckedByTag(srcValue[1]);
            rbnG0.SetCheckedByTag(srcValue[1]);
            rbnG1.SetCheckedByTag(srcValue[1]);
            rbnBR.SetCheckedByTag(srcValue[2]);
            rbnBG.SetCheckedByTag(srcValue[2]);
            rbnBB.SetCheckedByTag(srcValue[2]);
            rbnBA.SetCheckedByTag(srcValue[2]);
            rbnB0.SetCheckedByTag(srcValue[2]);
            rbnB1.SetCheckedByTag(srcValue[2]);
            rbnAR.SetCheckedByTag(srcValue[3]);
            rbnAG.SetCheckedByTag(srcValue[3]);
            rbnAB.SetCheckedByTag(srcValue[3]);
            rbnAA.SetCheckedByTag(srcValue[3]);
            rbnA0.SetCheckedByTag(srcValue[3]);
            rbnA1.SetCheckedByTag(srcValue[3]);
        }
    }
}
