﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Linq;
using App.Data;
using App.Utility;
using App.res;
using ConfigCommon;

namespace App.Controls
{
    /// <summary>
    /// アニメーション作成ダイアログクラス。
    /// </summary>
    public sealed partial class SceneAnimationCreateDialog : OkCancelDialog
    {
        private readonly GuiObjectID id_;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public SceneAnimationCreateDialog(GuiObjectID id)
        {
            InitializeComponent();

            id_ = id;

            tbxName.Focus();
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool OnResultOk()
        {
            // アニメーション名の整合確認
            string name = AnimationName;

            // 空文字
            if (name == string.Empty)
            {
                UIMessageBox.Warning(Strings.AnimationCreateDialog_NameEmpty);
                return false;
            }

            // 同名チェック
            if (DocumentManager.Animations.Any(x => x.ObjectID == id_ && x.Name == name))
            {
                UIMessageBox.Warning(Strings.IO_Name_Collision, name);
                return false;
            }

            // 正規表現
            if (RegexMatch.Check(name, "[0-9A-Za-z\\-\\._]+") == false)
            {
                UIMessageBox.Warning(string.Format(Strings.IO_Name_Invalid, name));
                return false;
            }

            return true;
        }

        /// <summary>
        /// アニメーション名。
        /// </summary>
        public string AnimationName { get { return tbxName.Text; } }

    }
}

