﻿using System.Collections.Generic;
using System.Linq;
using App.Utility;

namespace App.Controls
{
    public sealed partial class AnimationSetCreateDialog : OkCancelDialog
    {
        private readonly IEnumerable<string> NgNames;
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public AnimationSetCreateDialog(string name, IEnumerable<string> names)
        {
            InitializeComponent();

            DialogUtility.SetHelp(this, HelpUtility.PageKey.p_file_view_a_new_anim_set);

            tbxName.Text = name;

            NgNames = names;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool OnResultOk()
        {
            // アニメーション名の整合確認
            string name = AnimationSetName;

            // 空文字
            if (string.IsNullOrWhiteSpace(name))
            {
                UIMessageBox.Warning(res.Strings.AnimationSetCreateDialog_NameEmpty);
                return false;
            }
            // 重複
            if (NgNames.Contains(name))
            {
                UIMessageBox.Warning(res.Strings.AnimationSetCreateDialog_NameDuplicate);
                return false;
            }

            return true;
        }

        /// <summary>
        /// アニメーション名。
        /// </summary>
        public string AnimationSetName { get { return tbxName.Text; } }
    }
}
