﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using App.Utility;
using App.Win32;
using Microsoft.VisualBasic.ApplicationServices;

namespace App.Controls
{
    /// <summary>
    /// バージョン情報ダイアログクラス。
    /// </summary>
    public sealed partial class AboutDialog : OkDialog
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public AboutDialog()
        {
            InitializeComponent();

            MakeStringPath();
        }

        private readonly string productString_		= string.Format("{0} {1} ({2})", VersionInformation.Name, VersionInformation.Version, VersionInformation.BuildDate);
        private readonly string copyrightString_	= (new ApplicationBase()).Info.Copyright;
        private readonly Image iconImage_			= TheApp.MainFrame.Icon.ToBitmap();

        private const int productX_   = 80;
        private const int productY_   = 20;
        private const int copyrightX_ = 80;
        private const int copyrightY_ = 52;
        private const int iconX_      = 8+16;
        private const int iconY_      = 12+16;

        private void AboutDialog_Load(object sender, EventArgs e)
        {
            if (NativeMethods.DwmIsCompositionEnabled())
            {
                BackColor = Color.Black;
                btnOK.BackColor = SystemColors.Control;

                btnOK.UseCompatibleTextRendering = true;

                NativeMethods.DwmExtendFrameIntoClientArea(Handle, new NativeMethods.MARGINS(-1, 0, 0, 0));
            }
        }

        private readonly List<GraphicsPath>	outPath_ = new List<GraphicsPath>();
        private readonly List<GraphicsPath>	inPath_ = new List<GraphicsPath>();

        private void MakeStringPath()
        {
            var family = TheApp.GuiFont.FontFamily;
            var fontStyle = (int)TheApp.GuiFont.Style;
            var emSize = TheApp.GuiFont.SizeInPoints * 1.6f;
            var format = StringFormat.GenericDefault;

            // 外
            {
                const int r = 2;

                for(var y = -r;y <= +r;++ y)
                {
                    for(var x = -r;x <= +r;++ x)
                    {
                        if ((x == 0) && (y == 0))
                        {
                            continue;
                        }

                        var path = new GraphicsPath();

                        path.AddString(productString_  , family, fontStyle, emSize, new Point(productX_   + x, productY_   + y), format);
                        path.AddString(copyrightString_, family, fontStyle, emSize, new Point(copyrightX_ + x, copyrightY_ + y), format);

                        outPath_.Add(path);
                    }
                }
            }

            // 中
            {
                var path = new GraphicsPath();

                path.AddString(productString_  , family, fontStyle, emSize, new Point(productX_,   productY_),   format);
                path.AddString(copyrightString_, family, fontStyle, emSize, new Point(copyrightX_, copyrightY_), format);

                inPath_.Add(path);
            }
        }

        private void AboutDialog_Paint(object sender, PaintEventArgs e)
        {
            using (var hqg = new HighQualityGraphics(e.Graphics))
            {
                if (NativeMethods.DwmIsCompositionEnabled())
                {
                    // 外
                    using (var brush = new SolidBrush(Color.FromArgb(0x18, 0xFF, 0xFF, 0xFF)))
                    {
                        foreach(var path in outPath_)
                        {
                            e.Graphics.FillPath(brush, path);
                        }
                    }
                }

                // 中
                foreach(var path in inPath_)
                {
                    e.Graphics.FillPath(Brushes.Black, path);
                }

                // アイコン
                e.Graphics.DrawImage(iconImage_, iconX_, iconY_);
            }
        }

        protected override void WndProc(ref Message m)
        {
            // ウィンドウ全体をつかめるようにする

            const int WM_NCHITTEST = 0x84;
            const int HTCLIENT = 1;
            const int HTCAPTION = 2;

            base.WndProc (ref m);

            //マウスポインタがクライアント領域内にあるか
            if ((m.Msg == WM_NCHITTEST) && (m.Result.ToInt32() == HTCLIENT))
            {
                //マウスがタイトルバーにあるふりをする
                m.Result = (IntPtr) HTCAPTION;
            }
        }
    }
}
