﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.IO;
using System.Windows.Forms;
using App.Properties;

namespace App.res
{
    public static class ResCursors
    {
        private static Cursor hand_;
        private static Cursor magnify_;
        private static Cursor magnifyHorizontal_;
        private static Cursor magnifyVertical_;
        private static Cursor magnifyMinus_;
        private static Cursor magnifyPlus_;
        private static Cursor viewScale_;
        private static Cursor viewScroll_;

        public static Cursor Hand
        {
            get
            {
                return hand_ ?? (hand_ = new Cursor(new MemoryStream(Resources.Cursor_Hand)));
            }
        }

        public static Cursor Magnify
        {
            get
            {
                return magnify_ ?? (magnify_ = new Cursor(new MemoryStream(Resources.Cursor_Magnify)));
            }
        }

        public static Cursor MagnifyHorizontal
        {
            get
            {
                return magnifyHorizontal_ ?? (magnifyHorizontal_ = new Cursor(new MemoryStream(Resources.Cursor_MagnifyHorizontal)));
            }
        }

        public static Cursor MagnifyVertical
        {
            get
            {
                return magnifyVertical_ ?? (magnifyVertical_ = new Cursor(new MemoryStream(Resources.Cursor_MagnifyVertical)));
            }
        }

        public static Cursor MagnifyMinus
        {
            get
            {
                return magnifyMinus_ ?? (magnifyMinus_ = new Cursor(new MemoryStream(Resources.Cursor_MagnifyMinus)));
            }
        }

        public static Cursor MagnifyPlus
        {
            get
            {
                return magnifyPlus_ ?? (magnifyPlus_ = new Cursor(new MemoryStream(Resources.Cursor_MagnifyPlus)));
            }
        }

        public static Cursor ViewScale
        {
            get
            {
                return viewScale_ ?? (viewScale_ = new Cursor(new MemoryStream(Resources.Cursor_ViewScale)));
            }
        }

        public static Cursor ViewScroll
        {
            get
            {
                return viewScroll_ ?? (viewScroll_ = new Cursor(new MemoryStream(Resources.Cursor_ViewScroll)));
            }
        }
    }
}
