﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// C++/CLI でg3d のソースを使うために、DebugPrint を差し替えるダミーソースです。

#include <nw/g3d/g3d_config.h>

#include <cstdio>
#include <cstdarg>

#ifdef _WIN32
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <windows.h>
#include <malloc.h>
#include <crtdbg.h>
#else
#include <cafe/os.h>
#endif

namespace nw { namespace g3d {

#pragma warning(disable:4793) // vararg は /clr でサポートされてません。を抑制 処理としては適切ではないので後で修正。
void DebugPrint(const char* format, ...)
{
    NW_G3D_ASSERT_NOT_NULL(format);
}

}} // namespace nw::g3d
