﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nw/g3d//ut/g3d_Inlines.h>
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include <nw/g3d/res/g3d_ResAnimCurve.h>
#undef NOMINMAX

#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

#include <nn/util/util_BinTypes.h>

namespace nn {
    namespace g3d {
        struct ResAnimCurveData;
    }
}

namespace nw {
namespace g3d {
namespace tool {

class StringUtility
{
public:
    static void CopyString(s8* pOut, System::String^ pSource, size_t destSizeMax);
};

NW_G3D_FORCE_INLINE
size_t Align(size_t size, size_t alignment)
{
    size_t mask = alignment - 1;
    return (size + mask) & ~mask;
}

class Endian
{
public:
    //データのエンディアンを反転します。
    static void Swap(nw::g3d::edit::detail::PacketHeader* data);
    static void Swap(nn::g3d::viewer::detail::PacketHeader* data);
    static void Swap(nw::g3d::edit::detail::FileDataPacket* data);
    static void Swap(nw::g3d::edit::detail::EditValuePacket* data);
    static void Swap(nw::g3d::edit::detail::BindAnimPacket* data);
    static void Swap(nw::g3d::edit::detail::AnimCurvePacket* data);

    static void Swap(nw::g3d::edit::detail::FileDataBlock* data);
    static void Swap(nw::g3d::edit::detail::EditValueInfoBlock* data);
    static void Swap(nw::g3d::edit::detail::BindAnimInfoBlock* data);
    static void Swap(nw::g3d::edit::detail::AnimCurveBlock* data);
    static void Swap(nw::g3d::edit::detail::FrameCtrlPacket* data);
    static void Swap(nn::g3d::viewer::detail::FrameCtrlPacket* data);
    static void Swap(nw::g3d::edit::detail::RenderInfoEditPacket* data);
    static void Swap(nw::g3d::edit::detail::ModelLayoutRecvPacket* data);
    static void Swap(nw::g3d::edit::detail::ModelLayoutEditPacket* data);
    static void Swap(nw::g3d::edit::detail::BondBindEditPacket* data);
    static void Swap(nw::g3d::edit::detail::ShapeLodLevelEditPacket* data);
    static void Swap(nw::g3d::edit::detail::ModelOptimizedShaderPacket* data);
    static void Swap(nw::g3d::edit::detail::AnimEditInfoPacket* data);
    static void Swap(nw::g3d::edit::detail::RenderInfoUpdatePacket* data);
    static void Swap(nw::g3d::edit::detail::RenderInfoRecvPacket* data);
    static void Swap(nw::g3d::edit::detail::RuntimeErrorNotificationInfo* data);
    static void Swap(nn::g3d::viewer::detail::MessageNotificationInfo* data);

    static void Swap(nw::g3d::edit::detail::MultiFileDataBlock* data);
    static void SwapBindAnimationKeys(nw::g3d::edit::detail::BindAnimInfoBlock* data, u32 keySize);

    static void SwapValue(nw::g3d::edit::detail::EditValueBlock* data, bool isBoolType);
    static void SwapIndices(nw::g3d::edit::detail::EditValueBlock* data, u32 indexSize);

    static void SwapValue(nw::g3d::edit::detail::EditVector4ValueBlock* data);
    static void SwapIndices(nw::g3d::edit::detail::EditVector4ValueBlock* data, u32 indexSize);

    static void SwapValue(nw::g3d::edit::detail::EditSamplerValueBlock* data);
    static void SwapIndices(nw::g3d::edit::detail::EditSamplerValueBlock* data, u32 indexSize);

    static void SwapValue(nw::g3d::edit::detail::EditShaderParamVectorValueBlock* data, bool isBoolType);
    static void SwapIndices(nw::g3d::edit::detail::EditShaderParamVectorValueBlock* data, u32 indexSize);

    static void SwapValue(nw::g3d::edit::detail::EditShaderParamMatrixValueBlock* data);
    static void SwapIndices(nw::g3d::edit::detail::EditShaderParamMatrixValueBlock* data, u32 indexSize);

    static void SwapResAnimCurveData(void* pResAnimCurveData);

    static void SwapIndices(nw::g3d::edit::detail::EditShadingModelValueBlock* data, u32 indexSize);

    static void Swap(nw::g3d::edit::detail::RenderInfoUpdateBlock* data);


    //--------------------------------------------------------------------------------
    // 受信用
    static void Swap(nw::g3d::edit::detail::AttachBlock* data);
    static void Swap(nw::g3d::edit::detail::FileLoadedBlock* data);
    static void Swap(nw::g3d::edit::detail::ModelLayoutEditBlock* data);
    static void Swap(nw::g3d::edit::detail::FrameCtrlBlock* data);
    static void Swap(nn::g3d::viewer::detail::FrameCtrlBlock* data);

    static void Swap(nw::g3d::edit::detail::RenderInfoSendInfo* info);
    static void Swap(nw::g3d::edit::detail::ShaderProgramSendInfo* info);
    static void Swap(nw::g3d::edit::detail::PickupSendInfo* info);
    //--------------------------------------------------------------------------------
public:
    static void Swap(nw::g3d::res::ResAnimCurveData* data);
    static void Swap(nn::g3d::ResAnimCurveData* data);

    static void Swap(bit16* data)
    {
        StoreRevU16(data, *data);
    }

    static void Swap(s32* data)
    {
        union
        {
            s32* s32;
            bit32* bit32;
        } ptr = { data };
        Swap(ptr.bit32);
    }
    static void Swap(bit32* data)
    {
        StoreRevU32(data, *data);
    }
private:
    static void Swap(nw::g3d::edit::detail::RenderInfoRecvBlock* data);

    static void Swap(void* data, int typeSize, int elemCount)
    {
        if (typeSize == 4)
        {
            for (u32* pData = static_cast<u32*>(data), *pEnd = pData + elemCount;
                pData != pEnd; ++pData)
            {
                StoreRevU32(pData, *pData);
            }
        }
        else if (typeSize == 2)
        {
            for (u16* pData = static_cast<u16*>(data), *pEnd = pData + elemCount;
                pData != pEnd; ++pData)
            {
                StoreRevU16(pData, *pData);
            }
        }
        else if (typeSize != 1)
        {
            NW_G3D_NOT_SUPPORTED();
        }
    }

    template<class T>
    static void SwapArray(Offset* data, int size)
    {
        for (int i = 0; i < size; ++i)
        {
            Swap(&data->to_ptr<T>()[i]);
        }
    }

    template<class T>
    static void SwapArray(T* data, int size)
    {
        for (int i = 0; i < size; ++i)
        {
            Swap(&data[i]);
        }
    }

    static void Swap(s8*) {}

    static void Swap(bit8*) {}

    static void Swap(s16* data)
    {
        Swap(reinterpret_cast<bit16*>(data));
    }

    static void Swap(f32* data)
    {
        union
        {
            f32* f32;
            bit32* bit32;
        } ptr = { data };
        Swap(ptr.bit32);
    }

    static void Swap(nw::g3d::res::Offset* data)
    {
        s32 offset = *data;
        Swap(&offset);
        *data = offset;
    }

    static void Swap(nn::util::BinTPtr<void>* data)
    {
        nn::util::BinTPtr<void>::difference_type offset = data->GetOffset();
        nn::util::SwapEndian<nn::util::BinTPtr<void>::difference_type>(&offset);
        data->SetOffset(0, reinterpret_cast<void*>(offset));
    }
};

}}} // namespace nw::g3d::tool

namespace NintendoWare {
namespace G3d {
namespace Edit {

    NW_G3D_FORCE_INLINE void SetOffset(nn::util::BinPtr* pBinPtr, void* data)
    {
        pBinPtr->SetOffset(pBinPtr, data);
    }

    template<typename T>
    NW_G3D_FORCE_INLINE T* GetPtr(nn::util::BinPtr* pBinPtr)
    {
        return reinterpret_cast<T*>(pBinPtr->ToPtr(pBinPtr));
    }

    class ResAbstractionUtility
    {
    public:
        static size_t GetResAnimCurveSize();
    };

    void ReadResShaderFileAlignment(size_t* pOutAlignment, System::String^ fileName);
}}}
