﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "G3dHioLibDefs.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class TextureCommandMaker abstract sealed
{
public:
    static size_t CalcTextureBindingPacketSize(array<System::UInt32>^ textureKeys);

    static bool MakeBindTexturesPacket(
        array<System::Byte>^ packetBuffer,
        nn::g3d::viewer::detail::CommandFlag command,
        System::UInt32 targetKey,
        array<System::UInt32>^ textureKeys,
        TargetEndianKind endianKind);
};

}}} // namespace NintendoWare.G3d.Edit
