﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "SystemCommand.h"
#include "CommandMaker.h"

using namespace nw::g3d::edit::detail;

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool SystemBeginFreezeCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcSystemPacketSize();

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeSystemPacket(
        PacketBuffer,
        SYSTEM_BEGIN_FREEZE_COMMAND_FLAG,
        TargetEndian);
}

bool SystemEndFreezeCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcSystemPacketSize();

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeSystemPacket(
        PacketBuffer,
        SYSTEM_END_FREEZE_COMMAND_FLAG,
        TargetEndian);
}

bool SystemBeginFreezeNoSyncCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcSystemPacketSize();

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeSystemPacket(
        PacketBuffer,
        SYSTEM_BEGIN_FREEZE_NO_SYNC_COMMAND_FLAG,
        TargetEndian);
}

bool SystemResetRuntimeStateCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcSystemPacketSize();

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeSystemPacket(
        PacketBuffer,
        SYSTEM_RUNTIME_STATE_NORMAL_COMMAND_FLAG,
        TargetEndian);
}

bool SystemEditSelectTargetCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcEditValuePacketSize(Indices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    CommandFlag command;
    switch (m_Kind)
    {
    case SelectTargetKind::Model:
        command = PICK_RUNTIME_MODEL_COMMAND_FLAG;
        break;
    case SelectTargetKind::Material:
        command = PICK_RUNTIME_MATERIAL_COMMAND_FLAG;
        break;
    case SelectTargetKind::Bone:
        command = PICK_RUNTIME_BONE_COMMAND_FLAG;
        break;
    case SelectTargetKind::Shape:
        command = PICK_RUNTIME_SHAPE_COMMAND_FLAG;
        break;
    default:
        return false;
    }

    return CommandMaker::MakeEditValuePacket(
        PacketBuffer,
        command,
        EDIT_TARGET_KIND_MAX,
        Target->ModelObjKey,
        Indices,
        0,
        TargetEndian);
}

bool SystemRuntimeDebugLogCommand::MakeCommandPacket()
{
    array<INT32>^ dummyIndices = gcnew array<INT32>(1);
    int packetSize = CommandMaker::CalcEditValuePacketSize(dummyIndices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeEditValuePacket(
        PacketBuffer,
        static_cast<CommandFlag>(SYSTEM_RUNTIME_LOG_COMMAND_FLAG),
        EDIT_TARGET_KIND_MAX,
        0,
        dummyIndices,
        m_IsRuntimeDebugLogEnabled? 1 : 0,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
