﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "G3dHioLibDefs.h"

#include <WinSock2.h>
#pragma comment(lib, "Ws2_32.lib")

#include <nw/g3d/edit/g3d_EditDefs.h>

namespace nw {
namespace g3d {
namespace tool {

class Socket
{
public:
    explicit Socket();
    ~Socket();

    NintendoWare::G3d::Edit::HtcResult^ Open();
    void Close();

    NintendoWare::G3d::Edit::HtcResult^ Connect( u16 port, const char* addr = "127.0.0.1" );

    bool SetBlockMode();

    NintendoWare::G3d::Edit::HtcResult^ Recv(int* o_receiveBytes, char* buf, int len );
    NintendoWare::G3d::Edit::HtcResult^ Send(int* o_sentBytes, char* buf, int len );

    bool ReadSync( void* buf, int size );
    bool WriteSync( const void* buf, int size );

    bool ReadASync( void* buf, int size );
    bool IsReading() const;
    void ResetReadFlag();

    void Poll();
    bool IsConnected() const;

    void SetDebugLogEnabled()
    {
        m_IsDebugLogEnabled = true;
    }

    void SetDebugLogDisabled()
    {
        m_IsDebugLogEnabled = false;
    }

private:
    void ReadASyncInternal();

private:
    volatile SOCKET     m_Socket;
    char*               m_pReadBuffer;
    volatile u32        m_ReadBufferSize;
    volatile u32        m_ReadSize;
    volatile u32        m_ReadingSize;
    volatile u32        m_TotalReadingSize;
    volatile bool       m_IsReadEnd;
    volatile bool       m_IsDebugLogEnabled;
};

}}} // namespace nw::g3d::tool
