﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// g3dhiolib.h

#pragma once

#include "G3dHioLibDefs.h"
#include "EditBinAnimCurve.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class SceneAnimCommandMaker abstract sealed
{
public:
    static bool MakeBindSceneAnimationsPacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::CommandFlag command,
        array<UINT32>^ animationKeys,
        TargetEndianKind endianKind);

    static bool MakeEditCameraAnimCurvePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::tool::EditBinAnimCurve* animCurve,
        UINT32 animationKey,
        UINT32 cameraIndex,
        INT32 curveIndex,
        TargetEndianKind endianKind);

    static bool MakeEditLightAnimCurvePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::tool::EditBinAnimCurve* animCurve,
        UINT32 animationKey,
        UINT32 lightIndex,
        INT32 curveIndex,
        TargetEndianKind endianKind);

    static bool MakeEditFogAnimCurvePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::tool::EditBinAnimCurve* animCurve,
        UINT32 animationKey,
        UINT32 fogIndex,
        INT32 curveIndex,
        TargetEndianKind endianKind);
};

}}} // namespace NintendoWare.G3d.Edit
