﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

using namespace System::Diagnostics;

#include "PCCommDevice.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare { namespace G3d { namespace Edit {

PCCommDevice::PCCommDevice(RecvInfo^ recvInfo)
    : CommDevice(61440, recvInfo, false)
{
}

PCCommDevice::~PCCommDevice()
{
}

PCCommDevice::!PCCommDevice()
{
}

HtcResult^ PCCommDevice::Connect()
{
    HtcResult^ result = m_Client->Connect( m_PortNumber );
    this->IsConnected = result->IsSuccess;
    return result;
}

HtcResult^ PCCommDevice::ConnectPing()
{
    // ここはあとで、動的に変更できるようにする。
    HtcResult^ result = m_Client->ConnectPing(nw::g3d::edit::detail::EDIT_PING_PORT_NUMBER);
    this->IsPingConnected = result->IsSuccess;
    return result;
}

}}} // namespace NintendoWare.G3d.Edit
