﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace NintendoWare {
namespace G3d {
namespace Edit {

//! @brief マテリアルに割り当てられたシェーダー情報です。
public ref class MaterialShaderInfo
{
public:
    //! @brief 対象マテリアルに対応するシェーダーアーカイブのインデックスです。
    property int ShaderArchiveIndex
    {
        int get() { return m_ShaderArchiveIndex; }
        void set(int value) { m_ShaderArchiveIndex = value; }
    }

    //! @brief 対象マテリアルが最適化処理の対象になっているかどうかを取得設定します。
    property bool IsOptimized
    {
        bool get() { return m_IsOptimized; }
        void set(bool value) { m_IsOptimized = value; }
    }

    //! @brief 対象マテリアルが最適化処理の対象になっている際に、
    //!        最適化シェーダー作成がスキップされたかどうかを取得設定します。
    property bool IsOptimizationSkipped
    {
        bool get() { return m_IsOptimizationSkipped; }
        void set(bool value) { m_IsOptimizationSkipped = value; }
    }

private:
    int m_ShaderArchiveIndex;
    bool m_IsOptimized;
    bool m_IsOptimizationSkipped;
};

}}}
