﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "G3dHioLibDefs.h"
#include "MaterialShaderInfo.h"
#include <types.h>

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class LoadModelCommand : public EditModelCommand
{
public:
    LoadModelCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, FileData^ fileData)
     : EditModelCommand(targetEndian, target)
     , m_FileData(gcnew FileData())
    {
        m_FileData->Alignment = fileData->Alignment;
        m_FileData->FileName = dynamic_cast<String^>(fileData->FileName->Clone());
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey == 0)
        {
            return true;
        }
        return false;
    }

private:
    initonly FileData^ m_FileData;
};

private ref class ReloadModelCommand : public EditModelCommand
{
public:
    ReloadModelCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, FileData^ fileData)
        : EditModelCommand(targetEndian, target)
        , m_FileData(gcnew FileData())
    {
        m_FileData->Alignment = fileData->Alignment;
        m_FileData->FileName = dynamic_cast<String^>(fileData->FileName->Clone());
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

private:
    initonly FileData^ m_FileData;
};

private ref class UnloadModelCommand : public EditModelCommand
{
public:
    UnloadModelCommand(TargetEndianKind targetEndian, IEditModelTarget^ target)
        : EditModelCommand(targetEndian, target)
    {
        m_ReservedModelObjKey = target->ModelObjKey;
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

    virtual void OnRemoved() override
    {
        Target->ResetStatus();
    }

protected:
    virtual bool CanProcessImpl() override
    {
        if (m_ReservedModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    UInt32 m_ReservedModelObjKey;
};

private ref class SendAttachModelCommand : public EditModelCommand
{
public:
    SendAttachModelCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, FileData^ fileData)
        : EditModelCommand(targetEndian, target)
        , m_FileData(gcnew FileData())
    {
        m_FileData->Alignment = fileData->Alignment;
        m_FileData->FileName = dynamic_cast<String^>(fileData->FileName->Clone());
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

private:
    initonly FileData^ m_FileData;
};

private ref class UnloadAllCommand : public EditCommand
{
public:
    UnloadAllCommand(TargetEndianKind targetEndian)
        : EditCommand(targetEndian)
    {
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }
protected:
    virtual bool CanProcessImpl() override
    {
        // 全体アンロードするので、常に実行可能
        return true;
    }
};

private ref class LoadModelShaderArchiveCommand : public EditModelCommand
{
public:
    LoadModelShaderArchiveCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ target,
        FileData^ bfresFileData,
        array<String^>^ fileNames,
        array<MaterialShaderInfo^>^ materialShaderInfos)
        : EditModelCommand(targetEndian, target)
    {
        m_FileNames = gcnew List<String^>();
        if (fileNames != nullptr)
        {
            int fileCount = fileNames->Length;
            for (int i = 0; i < fileCount; ++i)
            {
                m_FileNames->Add(fileNames[i] != nullptr ? dynamic_cast<String^>(fileNames[i]->Clone()) : nullptr);
            }
        }

        m_IsMaterialShaderInfos = gcnew List<MaterialShaderInfo^>();
        if (materialShaderInfos != nullptr)
        {
            int materialCount = materialShaderInfos->Length;
            for (int i = 0; i < materialCount; ++i)
            {
                m_IsMaterialShaderInfos->Add(materialShaderInfos[i]);
            }
        }

        m_BfresFileData = gcnew FileData();
        m_BfresFileData->Alignment = bfresFileData->Alignment;
        m_BfresFileData->FileName = dynamic_cast<String^>(bfresFileData->FileName->Clone());
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

private:
    initonly FileData^ m_BfresFileData;
    initonly List<String^>^ m_FileNames;
    initonly List<MaterialShaderInfo^>^ m_IsMaterialShaderInfos;
};

}}} // namespace NintendoWare.G3d.Edit
