﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "LoadAnimCommand.h"
#include "CommandMaker.h"
#include "Utility.h"

using namespace nw::g3d::edit::detail;
using namespace nw::g3d::tool;

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool LoadAnimCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileData->FileName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    bool success = CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_LOAD_FILE_COMMAND_FLAG,
        m_FildDataKind,
        Target->Key,
        0,
        m_FileData,
        TargetEndian);
    if (!success)
    {
        return false;
    }

    array<Byte>^ packetBuffer = PacketBuffer;
    pin_ptr<u8> bufferPtr = &packetBuffer[0];
    FileDataPacket* packet = reinterpret_cast<FileDataPacket*>(bufferPtr);
    if (!String::IsNullOrEmpty(m_RetargetingHostModelName))
    {
        if (m_RetargetingHostModelName->Length + 1 > NW_G3D_EDIT_FILENAME_MAX)
        {
            throw gcnew Exception("Retargeting host model name is too long");
        }

        StringUtility::CopyString(packet->block.retargetingHostModelName, m_RetargetingHostModelName, m_RetargetingHostModelName->Length + 1);
    }

    return true;
}

bool ReloadAnimCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileData->FileName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_RELOAD_FILE_COMMAND_FLAG,
        m_FildDataKind,
        Target->Key,
        Target->ResFileKey,
        m_FileData,
        TargetEndian);
}

bool UnloadAnimCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(String::Empty);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    FileData^ fileData = gcnew FileData();
    fileData->Alignment = 0;
    fileData->FileName = String::Empty;

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_UNLOAD_FILE_COMMAND_FLAG,
        m_FildDataKind,
        m_ReservedResFileKey,
        0,
        fileData,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
