﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class EditShadingModelCommand : public EditIndicesShaderCommand
{
public:
    EditShadingModelCommand(TargetEndianKind targetEndian, IEditShaderArchiveTarget^ target, array<INT32>^ shadingModelIndices)
        : EditIndicesShaderCommand(targetEndian, target, shadingModelIndices)
    {
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }
};

}}} // namespace NintendoWare.G3d.Edit
