﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "EditModelAnimCommand.h"
#include "AnimCommandMaker.h"

using namespace nw::g3d::edit::detail;

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool EditShaderParamCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;
    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, sizeof(bit32) * m_ComponentIndex, Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        MODEL_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_MODEL_ANIMATION_SHADER_PARAM_CURVE,
        Target->ResFileKey,
        m_MaterialNameIndex,
        m_CurveIndex,
        TargetEndian);
}

bool EditTexPatternCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;
    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, 0, Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        MODEL_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_MODEL_ANIMATION_TEX_PATTERN_CURVE,
        Target->ResFileKey,
        m_MaterialNameIndex,
        m_CurveIndex,
        TargetEndian);
}

bool EditMaterialCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;
    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, sizeof(bit32) * m_ComponentIndex, Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        MODEL_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_MODEL_ANIMATION_MATERIAL_CURVE,
        Target->ResFileKey,
        m_MaterialNameIndex,
        m_CurveIndex,
        TargetEndian);
}

bool EditMatVisibilityCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;
    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, m_AnimIndex, Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        MODEL_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_MODEL_ANIMATION_MAT_VISIBILITY_CURVE,
        Target->ResFileKey,
        0,
        m_CurveIndex,
        TargetEndian);
}

bool EditBoneVisibilityCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;
    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, m_AnimIndex, Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        MODEL_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_MODEL_ANIMATION_BONE_VISIBILITY_CURVE,
        Target->ResFileKey,
        0,
        m_CurveIndex,
        TargetEndian);
}

bool EditShapeCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;
    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, 0, Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        MODEL_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_MODEL_ANIMATION_SHAPE_CURVE,
        Target->ResFileKey,
        m_AnimIndex,
        m_CurveIndex,
        TargetEndian);
}

bool EditModelAnimPlayCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcAnimEditInfoPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    UINT32 modelKey = 0;
    if (m_TargetModel != nullptr)
    {
        modelKey = m_TargetModel->ModelObjKey;
    }

    return AnimCommandMaker::MakeAnimEditInfoPacket(
        PacketBuffer,
        modelKey,
        Target->ResFileKey,
        MODEL_ANIMATION_PLAY_COMMAND_FLAG,
        m_Value,
        TargetEndian);
}

bool EditModelAnimStopCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcAnimEditInfoPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    UINT32 modelKey = 0;
    if (m_TargetModel != nullptr)
    {
        modelKey = m_TargetModel->ModelObjKey;
    }

    return AnimCommandMaker::MakeAnimEditInfoPacket(
        PacketBuffer,
        modelKey,
        Target->ResFileKey,
        MODEL_ANIMATION_STOP_COMMAND_FLAG,
        m_Value,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
