﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

// 時間があれば、uint, int, float とかの型制約を入れたい
generic<typename ValueType>// where ValueType : value struct
private ref class EditMaterialValueCommand : public EditIndicesModelCommand<ValueType>
{
public:
    EditMaterialValueCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ materialIndices, ValueType value, nw::g3d::edit::detail::EditTargetKind editTargetKind)
     : EditIndicesModelCommand<ValueType>(targetEndian, target, materialIndices, value)
    {
        m_EditTargetKind = editTargetKind;
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    nw::g3d::edit::detail::EditTargetKind m_EditTargetKind;
};

private ref class EditMaterialValueU16Command : public EditIndicesModelCommand
{
public:
    EditMaterialValueU16Command(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ materialIndices, UINT16 highValue, UINT16 lowValue, nw::g3d::edit::detail::EditTargetKind editTargetKind)
        : EditIndicesModelCommand(targetEndian, target, materialIndices)
    {
        m_EditTargetKind = editTargetKind;
        m_HighValue = highValue;
        m_LowValue = lowValue;
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    nw::g3d::edit::detail::EditTargetKind m_EditTargetKind;
    UINT16 m_HighValue;
    UINT16 m_LowValue;
};

generic<typename ValueType>
private ref class EditMaterialSamplerValueCommand : public EditIndicesModelCommand<ValueType>
{
public:
    EditMaterialSamplerValueCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ materialIndices, INT32 samplerIndex, ValueType value, nw::g3d::edit::detail::EditTargetKind editTargetKind)
        : EditIndicesModelCommand<ValueType>(targetEndian, target, materialIndices, value)
    {
        m_EditTargetKind = editTargetKind;
        m_SamplerIndex = samplerIndex;
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    nw::g3d::edit::detail::EditTargetKind m_EditTargetKind;
    INT32 m_SamplerIndex;
};

private ref class EditMaterialVector4ValueFloatCommand : public EditIndicesModelCommand
{
public:
    EditMaterialVector4ValueFloatCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ materialIndices, array<float>^ value, nw::g3d::edit::detail::EditTargetKind editTargetKind)
        : EditIndicesModelCommand(targetEndian, target, materialIndices)
    {
        m_EditTargetKind = editTargetKind;
        m_Value = gcnew array<float>(value->Length);
        value->CopyTo(m_Value, 0);
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    nw::g3d::edit::detail::EditTargetKind m_EditTargetKind;
    array<float>^ m_Value;
};

generic<typename ValueType>
private ref class EditMaterialShaderParamVectorValueCommand : public EditIndicesModelCommand
{
public:
    EditMaterialShaderParamVectorValueCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ materialIndices, String^ paramName, array<ValueType>^ value, nw::g3d::edit::detail::EditTargetKind editTargetKind)
        : EditIndicesModelCommand(targetEndian, target, materialIndices)
    {
        m_EditTargetKind = editTargetKind;
        m_ParamName = dynamic_cast<String^>(paramName->Clone());
        m_Value = gcnew array<ValueType>(value->Length);
        value->CopyTo(m_Value, 0);
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    nw::g3d::edit::detail::EditTargetKind m_EditTargetKind;
    String^ m_ParamName;
    array<ValueType>^ m_Value;
};

private ref class EditMaterialShaderParamMatrixValueCommand : public EditIndicesModelCommand
{
public:
    EditMaterialShaderParamMatrixValueCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ materialIndices, String^ paramName, array<float>^ value, nw::g3d::edit::detail::EditTargetKind editTargetKind)
        : EditIndicesModelCommand(targetEndian, target, materialIndices)
    {
        m_EditTargetKind = editTargetKind;
        m_ParamName = dynamic_cast<String^>(paramName->Clone());
        m_Value = gcnew array<float>(value->Length);
        value->CopyTo(m_Value, 0);
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    nw::g3d::edit::detail::EditTargetKind m_EditTargetKind;
    String^ m_ParamName;
    array<float>^ m_Value;
};

private ref class EditBlinkMaterialsCommand : public EditIndicesModelCommand
{
public:
    EditBlinkMaterialsCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<INT32>^ materialIndices)
        : EditIndicesModelCommand(targetEndian, target, materialIndices)
    {
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }
};

}}} // namespace NintendoWare.G3d.Edit
