﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "EditBinDictionary.h"

namespace nw {
namespace g3d {
namespace tool {

class EditBinRenderInfo : public EditBinaryBlock
{
public:
    EditBinRenderInfo()
        : EditBinaryBlock()
        , m_Dictionary()
    {}

    void AddStringRenderInfo(const std::string& labelName, const std::vector<std::string>& values )
    {

    }
    void AddIntRenderInfo(const std::string& labelName, const std::vector<int>& values );
    void AddFloatRenderInfo(const std::string& labelName, const std::vector<float>& values );

    virtual void Build();
    virtual void CalcSize();
    virtual void Convert(const Context& ctx);
private:
    struct RenderInfoData
    {
        std::string labelName;
        std::vector<std::string> stringValues;
        std::vector<int> intValues;
        std::vector<float> floatValues;
    };

    std::vector<RenderInfoData*> m_DataArray;
private:
    EditBinDictionary m_Dictionary;
    std::vector<nw::g3d::res::ResRenderInfoData> m_RenderInfoDataArray;
};

}}} // namespace nw::g3d::tool
