﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class BindAnimsCommand : public EditModelAndAnimsCommand
{
public:
    BindAnimsCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<IEditTarget^>^ targetAnims)
        : EditModelAndAnimsCommand(targetEndian, target, targetAnims)
    {
    }

    virtual bool MakeCommandPacket() override;
};

private ref class UnbindAnimsCommand : public EditModelAndAnimsCommand
{
public:
    UnbindAnimsCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, array<IEditTarget^>^ targetAnims)
        : EditModelAndAnimsCommand(targetEndian, target, targetAnims)
    {
    }

    virtual bool MakeCommandPacket() override;
};

private ref class EditRetargetingHostModelCommand : public EditAnimCommand
{
public:
    EditRetargetingHostModelCommand(TargetEndianKind targetEndian, IEditTarget^ target, IEditModelTarget^ retargetHostModel)
        : EditAnimCommand(targetEndian, target)
        , m_RetargetingHostModel(retargetHostModel)
    {
    }

    virtual bool MakeCommandPacket() override;
private:
    IEditModelTarget^ m_RetargetingHostModel;
};

private ref class EditPlayMotionMirroringCommand : public EditAnimCommand
{
public:
    EditPlayMotionMirroringCommand(TargetEndianKind targetEndian, IEditTarget^ target, bool isEnabled)
        : EditAnimCommand(targetEndian, target)
        , m_IsEnabled(isEnabled)
    {
    }
    virtual bool MakeCommandPacket() override;
private:
    bool m_IsEnabled;
};

private ref class EditPlayPolicyCommand : public EditCommand
{
public:
    EditPlayPolicyCommand(TargetEndianKind targetEndian, nn::g3d::viewer::detail::EditPlayPolicyKind policy)
        : EditCommand(targetEndian)
    {
        m_Policy = policy;
    }

    virtual bool MakeCommandPacket() override;
protected:
    virtual bool CanProcessImpl() override
    {
        //フレームコントロール設定周りなので常に動作可能
        return true;
    }
private:
    nn::g3d::viewer::detail::EditPlayPolicyKind m_Policy;
};

private ref class EditPlayFrameCtrlCommand : public EditCommand
{
public:
    EditPlayFrameCtrlCommand(TargetEndianKind targetEndian, float frame)
        : EditCommand(targetEndian)
    {
        m_Frame = frame;
    }

    virtual bool MakeCommandPacket() override;
protected:
    virtual bool CanProcessImpl() override
    {
        //フレームコントロール設定周りなので常に動作可能
        return true;
    }
private:
    float m_Frame;
};

private ref class EditStopFrameCtrlCommand : public EditCommand
{
public:
    EditStopFrameCtrlCommand(TargetEndianKind targetEndian, float frame)
        : EditCommand(targetEndian)
    {
        m_Frame = frame;
    }

    virtual bool MakeCommandPacket() override;
protected:
    virtual bool CanProcessImpl() override
    {
        //フレームコントロール設定周りなので常に動作可能
        return true;
    }
private:
    float m_Frame;
};

private ref class EditFrameStepCommand : public EditCommand
{
public:
    EditFrameStepCommand(TargetEndianKind targetEndian, float value)
        : EditCommand(targetEndian)
    {
        m_Value = value;
    }

    virtual bool MakeCommandPacket() override;
protected:
    virtual bool CanProcessImpl() override
    {
        //フレームコントロール設定周りなので常に動作可能
        return true;
    }
private:
    float m_Value;
};

private ref class EditFrameCountCommand : public EditCommand
{
public:
    EditFrameCountCommand(TargetEndianKind targetEndian, float value)
        : EditCommand(targetEndian)
    {
        m_Value = value;
    }

    virtual bool MakeCommandPacket() override;
protected:
    virtual bool CanProcessImpl() override
    {
        //フレームコントロール設定周りなので常に動作可能
        return true;
    }
private:
    float m_Value;
};

private ref class EditStartFrameCommand : public EditCommand
{
public:
    EditStartFrameCommand(TargetEndianKind targetEndian, float value)
        : EditCommand(targetEndian)
    {
        m_Value = value;
    }

    virtual bool MakeCommandPacket() override;
protected:
    virtual bool CanProcessImpl() override
    {
        //フレームコントロール設定周りなので常に動作可能
        return true;
    }
private:
    float m_Value;
};

}}} // namespace NintendoWare.G3d.Edit
