﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "msclr/marshal.h"
#include "msclr/marshal_windows.h"
#include "msclr/marshal_cppstd.h"
#include "msclr/marshal_atl.h"

#include "CommandWriter.h"
#include "Utility.h"
#include "EditBinAnimCurve.h"
#include <nw/g3d/res/g3d_ResUtility.h>

using namespace System;
using namespace msclr::interop;

namespace NintendoWare { namespace G3d { namespace Edit {

bool CommandWriter::SendData(nw::g3d::tool::Socket* socket, array<Byte>^ buffer)
{
    if (socket == NULL || buffer == nullptr)
    {
        return false;
    }

    pin_ptr<u8> bufferPtr = &buffer[0];
    bool result = socket->WriteSync(bufferPtr, buffer->Length);
    bufferPtr = nullptr;
    return result;
}

}}} // namespace NintendoWare.G3d.Edit
