﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// g3dhiolib.h

#pragma once

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class CommandUtility abstract sealed
{
public:
    static nw::g3d::edit::detail::PacketHeader GetPacketHeader();
    static nn::g3d::viewer::detail::PacketHeader GetNnG3dViewerPacketHeader();
    static size_t GetPacketHeaderSize();
    static size_t GetFileDataBlockSize();
    static size_t GetEditValueInfoBlockSize();
    static size_t GetModelOptimizedShaderBlockSize(int fileCount, int materialCount);
};

}}} // namespace NintendoWare.G3d.Edit
