﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    internal class SendCommandTransaction : ICommandTransaction
    {
        private readonly SendCommandQueue commandQueue;
        private readonly int beginIndex;
        private readonly ISendCommand systemBeginCommand;
        private readonly ISendCommand systemEndCommand;

        internal SendCommandTransaction(SendCommandQueue commandQueue, ISendCommand beginCommand, ISendCommand endCommand)
        {
            this.commandQueue = commandQueue;
            this.commandQueue.AddTransaction();

            this.beginIndex = this.commandQueue.Count;
            this.systemBeginCommand = beginCommand;
            this.systemEndCommand = endCommand;
        }

        public void Dispose()
        {
#if false
            // インスタンス生成時と数が変わっていない場合は処理をせず抜ける
            if (this.beginIndex >= this.commandQueue.Count)
            {
                return;
            }
#endif
            if (this.beginIndex >= this.commandQueue.Count)
            {
                this.commandQueue.PushBack(this.systemBeginCommand);
                this.commandQueue.PushBack(this.systemEndCommand);
            }
            else
            {
                if (this.commandQueue.Insert(this.beginIndex, this.systemBeginCommand))
                {
                    this.commandQueue.PushBack(this.systemEndCommand);
                }
            }

            this.commandQueue.RemoveTransaction();
        }
    }

    public class SendCommandQueue : CommandQueue<ISendCommand>
    {
        private int transactionCount = 0;

        public bool IsCreatingTransaction
        {
            get
            {
                return this.transactionCount > 0;
            }
        }

        internal void ClearAll()
        {
            this.Clear();
            this.ResetTransaction();
        }

        internal void AddTransaction()
        {
            ++this.transactionCount;
        }

        internal void RemoveTransaction()
        {
            if (transactionCount > 0)
            {
                --this.transactionCount;
            }
        }

        public ICommandTransaction CreateCommandTransaction(ISendCommand beginCommand, ISendCommand endCommnad)
        {
            SendCommandTransaction transaction = new SendCommandTransaction(this, beginCommand, endCommnad);
            return transaction;
        }

        internal void ResetTransaction()
        {
            this.transactionCount = 0;
        }
    }
}
