﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.G3d.Edit.Math;
using System.ComponentModel;

namespace NintendoWare.G3d.Edit
{
    public abstract class RecvInfoBase : ObservableObject, IRecvInfo
    {
        private ushort codePage = 0;

        private byte majorVersion = 0;
        private byte minorVersion = 0;
        private byte microVersion = 0;
        private byte bugFixVersion = 0;

        private EventHandler<RuntimeErrorOccuredEventArgs> runtimeErrorOccured;
        private EventHandler<FileLoadedEventArgs> fileLoaded;
        private EventHandler<FileReloadedEventArgs> fileReloaded;
        private EventHandler<ModelFileReloadedEventArgs> modelFileReloaded;
        private EventHandler<ModelFileLoadedEventArgs> modelFileLoaded;
        private EventHandler<AttachModelReceivedArgs> attachModelReceived;
        private EventHandler<DetachModelReceivedArgs> detachModelReceived;
        private EventHandler<AttachShaderArchiveReceivedArgs> attachShaderArchiveReceived;
        private EventHandler<DetachShaderArchiveReceivedArgs> detachShaderArchiveReceived;
        private EventHandler<UpdatedShaderProgramReceivedArgs> updatedShaderProgramReceived;
        private EventHandler<RenderInfoReceivedArgs> renderInfoReceived;
        private EventHandler<ModelLayoutReceivedArgs> modelLayoutReceived;
        private EventHandler<AbnormalPacketReceivedArgs> abnormalPacketReceived;
        private EventHandler<IncorrectVersionReceivedArgs> incorrectVersionReceived;
        private EventHandler<SelectionTargetReceivedArgs> selectionTargetReceived;
        private EventHandler<CodePageUpdateReceivedArgs> codePageUpdateReceived;
        private EventHandler<BeginFreezeReceivedArgs> beginFreezeReceived;
        private EventHandler<EndFreezeReceivedArgs> endFreezeReceived;
        private EventHandler<PlayFrameCtrlReceivedArgs> playFrameCtrlReceived;
        private EventHandler<StopFrameCtrlReceivedArgs> stopFrameCtrlReceived;
        private EventHandler<SendFrameReceivedArgs> sendFrameReceived;
        private EventHandler<SendFrameStepReceivedArgs> sendFrameStepReceived;
        private EventHandler<SendModelNextAnimReceivedArgs> sendModelNextAnimReceived;
        private EventHandler<SendModelPrevAnimReceivedArgs> sendModelPrevAnimReceived;
        private EventHandler<SceneAnimFileLoadedArgs> sceneAnimFileLoaded;
        private EventHandler<SceneAnimFileReloadedArgs> sceneAnimFileReloaded;
        private EventHandler<ShowMessageRequestedArgs> showMessageRequested;

        protected RecvInfoBase()
        {
        }

        public event EventHandler<SceneAnimFileLoadedArgs> SceneAnimFileLoaded
        {
            add
            {
                this.sceneAnimFileLoaded += value;
            }

            remove
            {
                this.sceneAnimFileLoaded -= value;
            }
        }

        internal void CallSceneAnimFileLoadedEvent(SceneAnimFileLoadedArgs arg)
        {
            if (this.sceneAnimFileLoaded != null)
            {
                this.sceneAnimFileLoaded(this, arg);
            }
        }

        public event EventHandler<SceneAnimFileReloadedArgs> SceneAnimFileReloaded
        {
            add
            {
                this.sceneAnimFileReloaded += value;
            }

            remove
            {
                this.sceneAnimFileReloaded -= value;
            }
        }

        internal void CallSceneAnimFileReloadedEvent(SceneAnimFileReloadedArgs arg)
        {
            if (this.sceneAnimFileReloaded != null)
            {
                this.sceneAnimFileReloaded(this, arg);
            }
        }

        public event EventHandler<ShowMessageRequestedArgs> ShowMessageRequested
        {
            add
            {
                this.showMessageRequested += value;
            }

            remove
            {
                this.showMessageRequested -= value;
            }
        }

        internal void CallShowMessageRequestedEvent(ShowMessageRequestedArgs arg)
        {
            if (this.showMessageRequested != null)
            {
                this.showMessageRequested(this, arg);
            }
        }

        /// <summary>
        /// 受信処理を区間設定開始か判定します。
        /// </summary>
        public event EventHandler<BeginFreezeReceivedArgs> BeginFreezeReceived
        {
            add
            {
                this.beginFreezeReceived += value;
            }

            remove
            {
                this.beginFreezeReceived -= value;
            }
        }

        internal void CallBeginFreezeReceivedEvent(BeginFreezeReceivedArgs arg)
        {
            if (this.beginFreezeReceived != null)
            {
                this.beginFreezeReceived(this, arg);
            }
        }

        /// <summary>
        /// 受信処理を区間設定終了か判定します。
        /// </summary>
        public event EventHandler<EndFreezeReceivedArgs> EndFreezeReceived
        {
            add
            {
                this.endFreezeReceived += value;
            }

            remove
            {
                this.endFreezeReceived -= value;
            }
        }

        internal void CallEndFreezeReceivedEvent(EndFreezeReceivedArgs arg)
        {
            if (this.endFreezeReceived != null)
            {
                this.endFreezeReceived(this, arg);
            }
        }

        /// <summary>
        /// フレームコントロール再生の受信があったか判定します。
        /// </summary>
        public event EventHandler<PlayFrameCtrlReceivedArgs> PlayFrameCtrlReceived
        {
            add
            {
                this.playFrameCtrlReceived += value;
            }

            remove
            {
                this.playFrameCtrlReceived -= value;
            }
        }

        internal void CallPlayFrameCtrlReceivedEvent(PlayFrameCtrlReceivedArgs arg)
        {
            if (this.playFrameCtrlReceived != null)
            {
                this.playFrameCtrlReceived(this, arg);
            }
        }

        /// <summary>
        /// フレームコントロール停止の受信があったか判定します。
        /// </summary>
        public event EventHandler<StopFrameCtrlReceivedArgs> StopFrameCtrlReceived
        {
            add
            {
                this.stopFrameCtrlReceived += value;
            }

            remove
            {
                this.stopFrameCtrlReceived -= value;
            }
        }

        internal void CallStopFrameCtrlReceivedEvent(StopFrameCtrlReceivedArgs arg)
        {
            if (this.stopFrameCtrlReceived != null)
            {
                this.stopFrameCtrlReceived(this, arg);
            }
        }

        /// <summary>
        /// フレーム設定の受信があったか判定します。
        /// </summary>
        public event EventHandler<SendFrameReceivedArgs> SendFrameReceived
        {
            add
            {
                this.sendFrameReceived += value;
            }

            remove
            {
                this.sendFrameReceived -= value;
            }
        }

        internal void CallSendFrameReceivedEvent(SendFrameReceivedArgs arg)
        {
            if (this.sendFrameReceived != null)
            {
                this.sendFrameReceived(this, arg);
            }
        }

        /// <summary>
        /// フレームステップ設定の受信があったか判定します。
        /// </summary>
        public event EventHandler<SendFrameStepReceivedArgs> SendFrameStepReceived
        {
            add
            {
                this.sendFrameStepReceived += value;
            }

            remove
            {
                this.sendFrameStepReceived -= value;
            }
        }

        internal void CallSendFrameStepReceivedEvent(SendFrameStepReceivedArgs arg)
        {
            if (this.sendFrameStepReceived != null)
            {
                this.sendFrameStepReceived(this, arg);
            }
        }

        /// <summary>
        /// ひとつ先のアニメーションセットを選択の受信があったか判定します。
        /// </summary>
        public event EventHandler<SendModelNextAnimReceivedArgs> SendModelNextAnimReceived
        {
            add
            {
                this.sendModelNextAnimReceived += value;
            }

            remove
            {
                this.sendModelNextAnimReceived -= value;
            }
        }

        internal void CallSendModelNextAnimReceivedEvent(SendModelNextAnimReceivedArgs arg)
        {
            if (this.sendModelNextAnimReceived != null)
            {
                this.sendModelNextAnimReceived(this, arg);
            }
        }

        /// <summary>
        /// ひとつ前のアニメーションセットを選択の受信があったか判定します。
        /// </summary>
        public event EventHandler<SendModelPrevAnimReceivedArgs> SendModelPrevAnimReceived
        {
            add
            {
                this.sendModelPrevAnimReceived += value;
            }

            remove
            {
                this.sendModelPrevAnimReceived -= value;
            }
        }

        internal void CallSendModelPrevAnimReceivedEvent(SendModelPrevAnimReceivedArgs arg)
        {
            if (this.sendModelPrevAnimReceived != null)
            {
                this.sendModelPrevAnimReceived(this, arg);
            }
        }

        /// <summary>
        /// バージョンが一致しないパケットを受信したときにコールされます。
        /// </summary>
        public event EventHandler<IncorrectVersionReceivedArgs> IncorrectVersionReceived
        {
            add
            {
                this.incorrectVersionReceived += value;
            }

            remove
            {
                this.incorrectVersionReceived -= value;
            }
        }

        /// <summary>
        /// 選択対象の返答があったときにコールされます。
        /// </summary>
        public event EventHandler<SelectionTargetReceivedArgs> SelectionTargetReceived
        {
            add
            {
                this.selectionTargetReceived += value;
            }

            remove
            {
                this.selectionTargetReceived -= value;
            }
        }

        /// <summary>
        /// コードページ更新の受信があったときにコールされます。
        /// </summary>
        public event EventHandler<CodePageUpdateReceivedArgs> CodePageUpdateReceived
        {
            add
            {
                this.codePageUpdateReceived += value;
            }

            remove
            {
                this.codePageUpdateReceived -= value;
            }
        }

        internal void CallIncorrectVersionReceivedEvent(IncorrectVersionReceivedArgs arg)
        {
            if (this.incorrectVersionReceived != null)
            {
                this.incorrectVersionReceived(this, arg);
            }
        }

        internal void CallSelectionTargetReceivedEvent(SelectionTargetReceivedArgs arg)
        {
            if (this.selectionTargetReceived != null)
            {
                this.selectionTargetReceived(this, arg);
            }
        }

        internal void CallCodePageUpdateReceivedEvent(CodePageUpdateReceivedArgs arg)
        {
            if (this.codePageUpdateReceived != null)
            {
                this.codePageUpdateReceived(this, arg);
            }
        }

        /// <summary>
        /// ランタイムでエラーが発生した時に実行されるイベントです。
        /// </summary>
        public event EventHandler<RuntimeErrorOccuredEventArgs> RuntimeErrorOccured
        {
            add
            {
                this.runtimeErrorOccured += value;
            }

            remove
            {
                this.runtimeErrorOccured -= value;
            }
        }

        internal void CallRuntimeErrorOccuredEvent(RuntimeError runtimeError)
        {
            if (this.runtimeErrorOccured != null)
            {
                this.runtimeErrorOccured(this, new RuntimeErrorOccuredEventArgs(runtimeError));
            }
        }

        public event EventHandler<FileLoadedEventArgs> FileLoaded
        {
            add
            {
                this.fileLoaded += value;
            }

            remove
            {
                this.fileLoaded -= value;
            }
        }

        public event EventHandler<FileReloadedEventArgs> FileReloaded
        {
            add
            {
                this.fileReloaded += value;
            }

            remove
            {
                this.fileReloaded -= value;
            }
        }

        public event EventHandler<ModelFileReloadedEventArgs> ModelFileReloaded
        {
            add
            {
                this.modelFileReloaded += value;
            }

            remove
            {
                this.modelFileReloaded -= value;
            }
        }

        internal void CallFileLoadedEvent(FileLoadedEventArgs arg)
        {
            if (this.fileLoaded != null)
            {
                this.fileLoaded(this, arg);
            }
        }

        internal void CallFileReloadedEvent(FileReloadedEventArgs arg)
        {
            if (this.fileReloaded != null)
            {
                this.fileReloaded(this, arg);
            }
        }

        internal void CallModelFileReloadedEvent(ModelFileReloadedEventArgs arg)
        {
            if (this.modelFileReloaded != null)
            {
                this.modelFileReloaded(this, arg);
            }
        }

        public event EventHandler<ModelFileLoadedEventArgs> ModelFileLoaded
        {
            add
            {
                this.modelFileLoaded += value;
            }

            remove
            {
                this.modelFileLoaded -= value;
            }
        }

        internal void CallModelFileLoadedEvent(ModelFileLoadedEventArgs arg)
        {
            if (this.modelFileLoaded != null)
            {
                this.modelFileLoaded(this, arg);
            }
        }

        public event EventHandler<AttachModelReceivedArgs> AttachModelReceived
        {
            add
            {
                this.attachModelReceived += value;
            }

            remove
            {
                this.attachModelReceived -= value;
            }
        }

        public event EventHandler<AttachShaderArchiveReceivedArgs> AttachShaderArchiveReceived
        {
            add
            {
                this.attachShaderArchiveReceived += value;
            }

            remove
            {
                this.attachShaderArchiveReceived -= value;
            }
        }

        public event EventHandler<UpdatedShaderProgramReceivedArgs> UpdatedShaderProgramReceived
        {
            add
            {
                this.updatedShaderProgramReceived += value;
            }

            remove
            {
                this.updatedShaderProgramReceived -= value;
            }
        }

        /// <summary>
        /// 描画情報要求後の返答があったときに呼ばれるイベントハンドラです。
        /// </summary>
        public event EventHandler<RenderInfoReceivedArgs> RenderInfoReceived
        {
            add
            {
                this.renderInfoReceived += value;
            }

            remove
            {
                this.renderInfoReceived -= value;
            }
        }

        internal void CallRenderInfoReceivedEvent(RenderInfoReceivedArgs arg)
        {
            if (this.renderInfoReceived != null)
            {
                this.renderInfoReceived(this, arg);
            }
        }

        internal void CallAttachModelReceivedEvent(AttachModelReceivedArgs arg)
        {
            if (this.attachModelReceived != null)
            {
                this.attachModelReceived(this, arg);
            }
        }

        public event EventHandler<DetachModelReceivedArgs> DetachModelReceived
        {
            add
            {
                this.detachModelReceived += value;
            }

            remove
            {
                this.detachModelReceived -= value;
            }
        }

        public event EventHandler<DetachShaderArchiveReceivedArgs> DetachShaderArchiveReceived
        {
            add
            {
                this.detachShaderArchiveReceived += value;
            }

            remove
            {
                this.detachShaderArchiveReceived -= value;
            }
        }

        internal void CallDetachModelReceivedEvent(DetachModelReceivedArgs arg)
        {
            if (this.detachModelReceived != null)
            {
                this.detachModelReceived(this, arg);
            }
        }

        internal void CallDetachShaderArchiveReceivedEvent(DetachShaderArchiveReceivedArgs arg)
        {
            if (this.detachShaderArchiveReceived != null)
            {
                this.detachShaderArchiveReceived(this, arg);
            }
        }

        internal void CallAttachShaderArchiveReceivedEvent(AttachShaderArchiveReceivedArgs arg)
        {
            if (this.attachShaderArchiveReceived != null)
            {
                this.attachShaderArchiveReceived(this, arg);
            }
        }

        public event EventHandler<ModelLayoutReceivedArgs> ModelLayoutReceived
        {
            add
            {
                this.modelLayoutReceived += value;
            }

            remove
            {
                this.modelLayoutReceived -= value;
            }
        }

        internal void CallModelLayoutReceivedEvent(ModelLayoutReceivedArgs arg)
        {
            if (this.modelLayoutReceived != null)
            {
                this.modelLayoutReceived(this, arg);
            }
        }

        public event EventHandler<AbnormalPacketReceivedArgs> AbnormalPacketReceived
        {
            add
            {
                this.abnormalPacketReceived += value;
            }

            remove
            {
                this.abnormalPacketReceived -= value;
            }
        }

        internal void CallAbnormalPacketReceivedEvent(AbnormalPacketReceivedArgs arg)
        {
            if (this.abnormalPacketReceived != null)
            {
                this.abnormalPacketReceived(this, arg);
            }
        }

        internal void CallUpdatedShaderProgramReceivedEvent(UpdatedShaderProgramReceivedArgs args)
        {
            if (this.updatedShaderProgramReceived != null)
            {
                this.updatedShaderProgramReceived(this, args);
            }
        }

        public ushort CodePage
        {
            get { return this.codePage; }
            protected internal set
            {
                this.codePage = value;
                this.OnPropertyChanged("CodePage");
            }
        }

        public byte MajorVersion
        {
            get { return this.majorVersion; }
            protected internal set
            {
                this.majorVersion = value;
                this.OnPropertyChanged("MajorVersion");
            }
        }

        public byte MinorVersion
        {
            get { return this.minorVersion; }
            protected internal set
            {
                this.minorVersion = value;
                this.OnPropertyChanged("MinorVersion");
            }
        }

        public byte MicroVersion
        {
            get { return this.microVersion; }
            protected internal set
            {
                this.microVersion = value;
                this.OnPropertyChanged("MicroVersion");
            }
        }

        public byte BugFixVersion
        {
            get { return this.bugFixVersion; }
            protected internal set
            {
                this.bugFixVersion = value;
                this.OnPropertyChanged("BugFixVersion");
            }
        }
    }
}
