﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public class PickupRecvData
    {
        private readonly Dictionary<uint, MaterialSelectionInfo> materialSelectionInfoArray = new Dictionary<uint, MaterialSelectionInfo>();
        private bool isClearMaterialSelection = false;
        public PickupRecvData()
        { }

        public bool IsClearMaterialSelection
        {
            get
            {
                return this.isClearMaterialSelection;
            }
        }

        public IList<MaterialSelectionInfo> MaterialSelectionTargetArray
        {
            get
            {
                return this.materialSelectionInfoArray.Values.ToList<MaterialSelectionInfo>();
            }
        }

        public void AddMaterialSelectionInfo(uint modelObjKey, int materialIndex)
        {
            MaterialSelectionInfo materialSelectionInfo = null;

            // materialIndex が -1 の時は、選択解除のときしかこない前提
            if (materialIndex == -1)
            {
                isClearMaterialSelection = true;
            }

            if (this.materialSelectionInfoArray.TryGetValue(modelObjKey, out materialSelectionInfo))
            {
                materialSelectionInfo.MaterialIndices.Add(materialIndex);
                return;
            }

            materialSelectionInfo = new MaterialSelectionInfo(modelObjKey);
            materialSelectionInfo.MaterialIndices.Add(materialIndex);
            this.materialSelectionInfoArray.Add(modelObjKey, materialSelectionInfo);
        }
    }
}
