﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public class MaterialSelectionInfo : ISelectionTargetInfo
    {
        private uint modelObjKey = 0;
        private readonly HashSet<int> materialIndices = new HashSet<int>();

        public MaterialSelectionInfo(uint modelObjKey)
        {
            this.modelObjKey = modelObjKey;
        }

        /// <summary>
        /// 選択対象のModelを特定するキーを取得します。
        /// </summary>
        public uint ModelObjKey
        {
            get { return this.modelObjKey; }
        }

        /// <summary>
        /// 選択対象のマテリアルインデックスを取得します。
        /// </summary>
        public ISet<int> MaterialIndices
        {
            get
            {
                return this.materialIndices;
            }
        }
    }

    /// <summary>
    /// 選択クリアクラス
    /// </summary>
    public class ClearMaterialSelectionInfo : ISelectionTargetInfo
    { }
}
