﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace NintendoWare.G3d.Edit
{
    public interface IHIO : INotifyPropertyChanged
    {
        HIOBase.TargetType TargetDeviceType { get; }
        bool IsConnected { get; }
        bool IsAutoConnection { get; set; }

        bool IsPingReceived { get; }

        IRecvInfo RecvInfo { get; }

        RuntimeState GetRuntimeState();

        HtcResult Open();
        void Close();

        /// <summary>
        /// 通信接続確認用のPoll 処理
        /// </summary>
        void PollPing();

        void SelectTargetMaterials(IEditModelTarget targetModel, int[] indices);
        void SelectTargetBones(IEditModelTarget targetModel, int[] indices);
        void SelectTargetShapes(IEditModelTarget targetModel, int[] indices);
        void SelectTargetModel(IEditModelTarget targetModel);

        void ClearSelectedMaterials();
        void ClearSelectedBones();
        void ClearSelectedShapes();
        void ClearSelectedModels();

        ICommandTransaction BeginCommand();
        ICommandTransaction BeginCommand(bool sync);
    }
}
