﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit.Math
{
    public sealed class TextureSRT3D
    {
        private readonly Vector3 scale = new Vector3();
        private readonly Vector3 rotate = new Vector3();
        private readonly Vector3 trans = new Vector3();

        public Vector3 Scale
        {
            get { return this.scale; }
        }

        public Vector3 Rotate
        {
            get { return this.rotate; }
        }

        public Vector3 Trans
        {
            get { return this.trans; }
        }

        /// <summary>
        /// 要素を格納した配列を返します。
        /// </summary>
        /// <returns>要素の配列です。</returns>
        public float[] ToArray()
        {
            float[] scale = this.scale.ToArray();
            float[] rotate = this.rotate.ToArray();
            float[] trans = this.trans.ToArray();

            return new float[]
            {
                scale[0], scale[1], scale[2],
                rotate[0], rotate[1], rotate[2],
                trans[0], trans[1], trans[2]
            };
        }
    }
}
