﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace NintendoWare.G3d.Edit
{
    public abstract class EditMaterialCommand : EditModelCommand
    {
        private readonly int[] materialIndices;
        protected EditMaterialCommand(TargetEndianKind targetEndian, IEditModelTarget target, int[] materialIndices)
            : base(targetEndian, target)
        {
            Debug.Assert(materialIndices != null, "Invalid argument.");
            this.materialIndices = new int[materialIndices.Length];
            materialIndices.CopyTo(this.materialIndices, 0);
        }

        protected int[] MaterialIndices
        {
            get
            {
                return this.materialIndices;
            }
        }
    }

    public abstract class EditMaterialCommand<T> : EditMaterialCommand// where T : struct
    {
        private readonly T value;
        protected EditMaterialCommand(TargetEndianKind targetEndian, IEditModelTarget target, int[] materialIndices, T value)
            : base(targetEndian, target, materialIndices)
        {
            this.value = value;
        }

        protected T Value
        {
            get
            {
                return this.value;
            }
        }
    }
}
