﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public abstract class EditCommand : Command, IEditCommand
    {
        private byte[] packetBuffer = null;

        protected EditCommand(TargetEndianKind targetEndian)
            : base(targetEndian)
        {
        }

        public byte[] PacketBuffer
        {
            get
            {
                return this.packetBuffer;
            }
        }

        public virtual bool IsSystemBeginCommand
        {
            get
            {
                return false;
            }
        }

        public virtual bool IsSystemEndCommand
        {
            get
            {
                return false;
            }
        }

        public virtual bool MakeCommandPacket()
        {
            throw new NotImplementedException();
        }

        protected void AllocPacketBuffer(int size)
        {
            this.packetBuffer = new byte[size];
        }
    }
}
