﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;
using System.Windows.Media;

namespace Nintendo.InGameEditing.WPF
{
    internal class StringToBrushConverter : IValueConverter
    {
        private static readonly IDictionary<string, Brush> predefinedBrushes;

        static StringToBrushConverter()
        {
            var flags = BindingFlags.Static | BindingFlags.Public;
            predefinedBrushes = typeof(Brushes)
                .GetProperties(flags)
                .Where(p => typeof(Brush).IsAssignableFrom(p.PropertyType))
                .ToDictionary(p => p.Name, p => (Brush)p.GetValue(null));
        }

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value == null) return Brushes.Transparent;
            var brush = default(Brush);
            predefinedBrushes.TryGetValue(value as string ?? string.Empty, out brush);
            return brush ?? DependencyProperty.UnsetValue;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
