﻿using System.Collections.Generic;
using System.ComponentModel;
using System.IO;

namespace Nintendo.InGameEditing.UI
{
    /// <summary>
    /// チェックボックスクラスです。
    /// </summary>
    public class CheckBoxModel : ControlModel
    {
        internal static readonly string UiType = "CheckBox";
        private static readonly PropertyChangedEventArgs IsCheckedEventArgs = new PropertyChangedEventArgs(nameof(IsChecked));
        private readonly ValueNode<bool> node;
        private bool currentValue;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="node">元になるノード</param>
        /// <param name="attrs">メタデータに指定された属性の辞書</param>
        internal CheckBoxModel(ValueNode<bool> node, Dictionary<string, string> attrs) : base(node, attrs)
        {
            this.node = node;
            node.ValueReceived += (s, e) => SetPropertyValue(ref currentValue, e.Value, IsCheckedEventArgs);
        }

        /// <summary>
        /// チェックされている状態かどうかを取得設定します。
        /// </summary>
        public bool IsChecked
        {
            get { return currentValue; }
            set
            {
                if (SetPropertyValue(ref currentValue, value, IsCheckedEventArgs))
                {
                    node.PushValue(value);
                }
            }
        }
    }
}
